/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluentImpl;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterBuilder;
import io.fabric8.kubernetes.api.model.NamedClusterFluentImpl;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextBuilder;
import io.fabric8.kubernetes.api.model.NamedContextFluentImpl;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.Preferences;
import io.fabric8.kubernetes.api.model.PreferencesBuilder;
import io.fabric8.kubernetes.api.model.PreferencesFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFluentImpl<T extends ConfigFluent<T>>
extends BaseFluent<T>
implements ConfigFluent<T> {
    String apiVersion;
    List<VisitableBuilder<NamedCluster, ?>> clusters = new ArrayList();
    List<VisitableBuilder<NamedContext, ?>> contexts = new ArrayList();
    String currentContext;
    List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();
    String kind;
    VisitableBuilder<Preferences, ?> preferences;
    List<VisitableBuilder<NamedAuthInfo, ?>> users = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ConfigFluentImpl() {
    }

    public ConfigFluentImpl(Config instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withClusters(instance.getClusters());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withExtensions(instance.getExtensions());
        this.withKind(instance.getKind());
        this.withPreferences(instance.getPreferences());
        this.withUsers(instance.getUsers());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToClusters(NamedCluster ... items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.add(builder);
            this.clusters.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromClusters(NamedCluster ... items) {
        for (NamedCluster item : items) {
            NamedClusterBuilder builder = new NamedClusterBuilder(item);
            this._visitables.remove(builder);
            this.clusters.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedCluster> getClusters() {
        return this.build(this.clusters);
    }

    @Override
    public T withClusters(List<NamedCluster> clusters) {
        this.clusters.clear();
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withClusters(NamedCluster ... clusters) {
        this.clusters.clear();
        if (clusters != null) {
            for (NamedCluster item : clusters) {
                this.addToClusters(item);
            }
        }
        return (T)this;
    }

    @Override
    public ConfigFluent.ClustersNested<T> addNewCluster() {
        return new ClustersNestedImpl();
    }

    @Override
    public ConfigFluent.ClustersNested<T> addNewClusterLike(NamedCluster item) {
        return new ClustersNestedImpl(item);
    }

    @Override
    public T addToContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.add(builder);
            this.contexts.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromContexts(NamedContext ... items) {
        for (NamedContext item : items) {
            NamedContextBuilder builder = new NamedContextBuilder(item);
            this._visitables.remove(builder);
            this.contexts.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedContext> getContexts() {
        return this.build(this.contexts);
    }

    @Override
    public T withContexts(List<NamedContext> contexts) {
        this.contexts.clear();
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withContexts(NamedContext ... contexts) {
        this.contexts.clear();
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (T)this;
    }

    @Override
    public ConfigFluent.ContextsNested<T> addNewContext() {
        return new ContextsNestedImpl();
    }

    @Override
    public ConfigFluent.ContextsNested<T> addNewContextLike(NamedContext item) {
        return new ContextsNestedImpl(item);
    }

    @Override
    public String getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public T withCurrentContext(String currentContext) {
        this.currentContext = currentContext;
        return (T)this;
    }

    @Override
    public T addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedExtension> getExtensions() {
        return this.build(this.extensions);
    }

    @Override
    public T withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    @Override
    public ConfigFluent.ExtensionsNested<T> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ConfigFluent.ExtensionsNested<T> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public Preferences getPreferences() {
        return this.preferences != null ? (Preferences)this.preferences.build() : null;
    }

    @Override
    public T withPreferences(Preferences preferences) {
        if (preferences != null) {
            this.preferences = new PreferencesBuilder(preferences);
            this._visitables.add(this.preferences);
        }
        return (T)this;
    }

    @Override
    public ConfigFluent.PreferencesNested<T> withNewPreferences() {
        return new PreferencesNestedImpl();
    }

    @Override
    public ConfigFluent.PreferencesNested<T> withNewPreferencesLike(Preferences item) {
        return new PreferencesNestedImpl(item);
    }

    @Override
    public ConfigFluent.PreferencesNested<T> editPreferences() {
        return this.withNewPreferencesLike(this.getPreferences());
    }

    @Override
    public T addToUsers(NamedAuthInfo ... items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.add(builder);
            this.users.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromUsers(NamedAuthInfo ... items) {
        for (NamedAuthInfo item : items) {
            NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
            this._visitables.remove(builder);
            this.users.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedAuthInfo> getUsers() {
        return this.build(this.users);
    }

    @Override
    public T withUsers(List<NamedAuthInfo> users) {
        this.users.clear();
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withUsers(NamedAuthInfo ... users) {
        this.users.clear();
        if (users != null) {
            for (NamedAuthInfo item : users) {
                this.addToUsers(item);
            }
        }
        return (T)this;
    }

    @Override
    public ConfigFluent.UsersNested<T> addNewUser() {
        return new UsersNestedImpl();
    }

    @Override
    public ConfigFluent.UsersNested<T> addNewUserLike(NamedAuthInfo item) {
        return new UsersNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigFluentImpl that = (ConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.clusters != null ? !this.clusters.equals(that.clusters) : that.clusters != null) {
            return false;
        }
        if (this.contexts != null ? !this.contexts.equals(that.contexts) : that.contexts != null) {
            return false;
        }
        if (this.currentContext != null ? !this.currentContext.equals(that.currentContext) : that.currentContext != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.preferences != null ? !this.preferences.equals(that.preferences) : that.preferences != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class UsersNestedImpl<N>
    extends NamedAuthInfoFluentImpl<ConfigFluent.UsersNested<N>>
    implements ConfigFluent.UsersNested<N> {
        private final NamedAuthInfoBuilder builder;

        UsersNestedImpl() {
            this.builder = new NamedAuthInfoBuilder(this);
        }

        UsersNestedImpl(NamedAuthInfo item) {
            this.builder = new NamedAuthInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToUsers(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }

    public class PreferencesNestedImpl<N>
    extends PreferencesFluentImpl<ConfigFluent.PreferencesNested<N>>
    implements ConfigFluent.PreferencesNested<N> {
        private final PreferencesBuilder builder;

        PreferencesNestedImpl() {
            this.builder = new PreferencesBuilder(this);
        }

        PreferencesNestedImpl(Preferences item) {
            this.builder = new PreferencesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.withPreferences(this.builder.build());
        }

        @Override
        public N endPreferences() {
            return this.and();
        }
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ConfigFluent.ExtensionsNested<N>>
    implements ConfigFluent.ExtensionsNested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNestedImpl() {
            this.builder = new NamedExtensionBuilder(this);
        }

        ExtensionsNestedImpl(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToExtensions(this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }

    public class ContextsNestedImpl<N>
    extends NamedContextFluentImpl<ConfigFluent.ContextsNested<N>>
    implements ConfigFluent.ContextsNested<N> {
        private final NamedContextBuilder builder;

        ContextsNestedImpl(NamedContext item) {
            this.builder = new NamedContextBuilder(this, item);
        }

        ContextsNestedImpl() {
            this.builder = new NamedContextBuilder(this);
        }

        @Override
        public N endContext() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToContexts(this.builder.build());
        }
    }

    public class ClustersNestedImpl<N>
    extends NamedClusterFluentImpl<ConfigFluent.ClustersNested<N>>
    implements ConfigFluent.ClustersNested<N> {
        private final NamedClusterBuilder builder;

        ClustersNestedImpl() {
            this.builder = new NamedClusterBuilder(this);
        }

        ClustersNestedImpl(NamedCluster item) {
            this.builder = new NamedClusterBuilder(this, item);
        }

        @Override
        public N endCluster() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ConfigFluentImpl.this.addToClusters(this.builder.build());
        }
    }
}

