package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class BuildRequestFluent<T extends BuildRequestFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     BuildRequest.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<SourceRevision, ?> revision;     VisitableBuilder<ObjectReference, ?> triggeredByImage;     Map<String, Object> additionalProperties = new HashMap();

    public BuildRequest.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( BuildRequest.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public SourceRevision getRevision(){
    return this.revision!=null?this.revision.build():null;
    }
    public T withRevision( SourceRevision revision){
    if (revision!=null){ this.revision= new SourceRevisionBuilder(revision); _visitables.add(this.revision);} return (T) this;
    }
    public RevisionNested<T> withNewRevision(){
    return new RevisionNested<T>();
    }
    public RevisionNested<T> withNewRevisionLike( SourceRevision item){
    return new RevisionNested<T>(item);
    }
    public RevisionNested<T> editRevision(){
    return withNewRevisionLike(getRevision());
    }
    public ObjectReference getTriggeredByImage(){
    return this.triggeredByImage!=null?this.triggeredByImage.build():null;
    }
    public T withTriggeredByImage( ObjectReference triggeredByImage){
    if (triggeredByImage!=null){ this.triggeredByImage= new ObjectReferenceBuilder(triggeredByImage); _visitables.add(this.triggeredByImage);} return (T) this;
    }
    public TriggeredByImageNested<T> withNewTriggeredByImage(){
    return new TriggeredByImageNested<T>();
    }
    public TriggeredByImageNested<T> withNewTriggeredByImageLike( ObjectReference item){
    return new TriggeredByImageNested<T>(item);
    }
    public TriggeredByImageNested<T> editTriggeredByImage(){
    return withNewTriggeredByImageLike(getTriggeredByImage());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) BuildRequestFluent.this.withMetadata(builder.build());
        }
    
}
    public class RevisionNested<N> extends SourceRevisionFluent<RevisionNested<N>> implements Nested<N>{

        private final SourceRevisionBuilder builder;
    
             RevisionNested (){
        this.builder = new SourceRevisionBuilder(this);
        }
             RevisionNested ( SourceRevision item){
        this.builder = new SourceRevisionBuilder(this, item);
        }
    
            public N endRevision(){
            return and();
        }
            public N and(){
            return (N) BuildRequestFluent.this.withRevision(builder.build());
        }
    
}
    public class TriggeredByImageNested<N> extends ObjectReferenceFluent<TriggeredByImageNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             TriggeredByImageNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             TriggeredByImageNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N endTriggeredByImage(){
            return and();
        }
            public N and(){
            return (N) BuildRequestFluent.this.withTriggeredByImage(builder.build());
        }
    
}


}
