package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PodSecurityContextFluent<T extends PodSecurityContextFluent<T>> extends Fluent<T>{


    public Long getFsGroup();    public T withFsGroup( Long fsGroup);    public Boolean isRunAsNonRoot();    public T withRunAsNonRoot( Boolean runAsNonRoot);    public Long getRunAsUser();    public T withRunAsUser( Long runAsUser);    public SELinuxOptions getSeLinuxOptions();    public T withSeLinuxOptions( SELinuxOptions seLinuxOptions);    public SeLinuxOptionsNested<T> withNewSeLinuxOptions();    public SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike( SELinuxOptions item);    public SeLinuxOptionsNested<T> editSeLinuxOptions();    public T withNewSeLinuxOptions( String level,  String role,  String type,  String user);    public T addToSupplementalGroups( Long ...items);    public T removeFromSupplementalGroups( Long ...items);    public List<Long> getSupplementalGroups();    public T withSupplementalGroups( List<Long> supplementalGroups);    public T withSupplementalGroups( Long ...supplementalGroups);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SeLinuxOptionsNested<N> extends Nested<N>, SELinuxOptionsFluent<SeLinuxOptionsNested<N>>{
            public N endSeLinuxOptions();            public N and();        
}


}
