package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ScaleStatusFluentImpl<T extends ScaleStatusFluent<T>> extends BaseFluent<T> implements ScaleStatusFluent<T>{

     Integer replicas;     Map<String, String> selector = new HashMap();     Map<String, Object> additionalProperties = new HashMap();
public ScaleStatusFluentImpl(){
    
}
public ScaleStatusFluentImpl( ScaleStatus instance ){
    this.withReplicas(instance.getReplicas()); this.withSelector(instance.getSelector()); 
}

    public Integer getReplicas(){
    return this.replicas;
    }
    public T withReplicas( Integer replicas){
    this.replicas=replicas; return (T) this;
    }
    public T addToSelector( String key,  String value){
    if(key != null && value != null) {this.selector.put(key, value);} return (T)this;
    }
    public T addToSelector( Map<String, String> map){
    if(map != null) { this.selector.putAll(map);} return (T)this;
    }
    public T removeFromSelector( String key){
    if(key != null) {this.selector.remove(key);} return (T)this;
    }
    public T removeFromSelector( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.selector.remove(key);}} return (T)this;
    }
    public Map<String, String> getSelector(){
    return this.selector;
    }
    public T withSelector( Map<String, String> selector){
    this.selector.clear();if (selector != null) {this.selector.putAll(selector);} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ScaleStatusFluentImpl that = (ScaleStatusFluentImpl) o;
if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
