
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "exec",
    "httpGet",
    "initialDelaySeconds",
    "tcpSocket",
    "timeoutSeconds"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class Probe {

    /**
     * 
     * 
     */
    @JsonProperty("exec")
    @Valid
    private ExecAction exec;
    /**
     * 
     * 
     */
    @JsonProperty("httpGet")
    @Valid
    private HTTPGetAction httpGet;
    /**
     * 
     * 
     */
    @JsonProperty("initialDelaySeconds")
    private Long initialDelaySeconds;
    /**
     * 
     * 
     */
    @JsonProperty("tcpSocket")
    @Valid
    private TCPSocketAction tcpSocket;
    /**
     * 
     * 
     */
    @JsonProperty("timeoutSeconds")
    private Long timeoutSeconds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Probe() {
    }

    /**
     * 
     * @param tcpSocket
     * @param timeoutSeconds
     * @param initialDelaySeconds
     * @param exec
     * @param httpGet
     */
    public Probe(ExecAction exec, HTTPGetAction httpGet, Long initialDelaySeconds, TCPSocketAction tcpSocket, Long timeoutSeconds) {
        this.exec = exec;
        this.httpGet = httpGet;
        this.initialDelaySeconds = initialDelaySeconds;
        this.tcpSocket = tcpSocket;
        this.timeoutSeconds = timeoutSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The exec
     */
    @JsonProperty("exec")
    public ExecAction getExec() {
        return exec;
    }

    /**
     * 
     * 
     * @param exec
     *     The exec
     */
    @JsonProperty("exec")
    public void setExec(ExecAction exec) {
        this.exec = exec;
    }

    /**
     * 
     * 
     * @return
     *     The httpGet
     */
    @JsonProperty("httpGet")
    public HTTPGetAction getHttpGet() {
        return httpGet;
    }

    /**
     * 
     * 
     * @param httpGet
     *     The httpGet
     */
    @JsonProperty("httpGet")
    public void setHttpGet(HTTPGetAction httpGet) {
        this.httpGet = httpGet;
    }

    /**
     * 
     * 
     * @return
     *     The initialDelaySeconds
     */
    @JsonProperty("initialDelaySeconds")
    public Long getInitialDelaySeconds() {
        return initialDelaySeconds;
    }

    /**
     * 
     * 
     * @param initialDelaySeconds
     *     The initialDelaySeconds
     */
    @JsonProperty("initialDelaySeconds")
    public void setInitialDelaySeconds(Long initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
    }

    /**
     * 
     * 
     * @return
     *     The tcpSocket
     */
    @JsonProperty("tcpSocket")
    public TCPSocketAction getTcpSocket() {
        return tcpSocket;
    }

    /**
     * 
     * 
     * @param tcpSocket
     *     The tcpSocket
     */
    @JsonProperty("tcpSocket")
    public void setTcpSocket(TCPSocketAction tcpSocket) {
        this.tcpSocket = tcpSocket;
    }

    /**
     * 
     * 
     * @return
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public Long getTimeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * 
     * 
     * @param timeoutSeconds
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public void setTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
