package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class HTTPIngressPathFluentImpl<T extends HTTPIngressPathFluent<T>> extends BaseFluent<T> implements HTTPIngressPathFluent<T>{

     VisitableBuilder<IngressBackend, ?> backend;     String path;     Map<String, Object> additionalProperties = new HashMap();
public HTTPIngressPathFluentImpl(){
    
}
public HTTPIngressPathFluentImpl( HTTPIngressPath instance ){
    this.withBackend(instance.getBackend()); this.withPath(instance.getPath()); 
}

    public IngressBackend getBackend(){
    return this.backend!=null?this.backend.build():null;
    }
    public T withBackend( IngressBackend backend){
    if (backend!=null){ this.backend= new IngressBackendBuilder(backend); _visitables.add(this.backend);} return (T) this;
    }
    public BackendNested<T> withNewBackend(){
    return new BackendNestedImpl<T>();
    }
    public BackendNested<T> withNewBackendLike( IngressBackend item){
    return new BackendNestedImpl<T>(item);
    }
    public BackendNested<T> editBackend(){
    return withNewBackendLike(getBackend());
    }
    public String getPath(){
    return this.path;
    }
    public T withPath( String path){
    this.path=path; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HTTPIngressPathFluentImpl that = (HTTPIngressPathFluentImpl) o;
if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class BackendNestedImpl<N> extends IngressBackendFluentImpl<BackendNested<N>> implements BackendNested<N>{

        private final IngressBackendBuilder builder;
    
             BackendNestedImpl (){
        this.builder = new IngressBackendBuilder(this);
        }
             BackendNestedImpl ( IngressBackend item){
        this.builder = new IngressBackendBuilder(this, item);
        }
    
            public N and(){
            return (N) HTTPIngressPathFluentImpl.this.withBackend(builder.build());
        }
            public N endBackend(){
            return and();
        }
    
}


}
