package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class PersistentVolumeSpecFluentImpl<T extends PersistentVolumeSpecFluent<T>> extends BaseFluent<T> implements PersistentVolumeSpecFluent<T>{

     List<String> accessModes = new ArrayList();     VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;     Map<String, Quantity> capacity = new HashMap();     VisitableBuilder<CephFSVolumeSource, ?> cephfs;     VisitableBuilder<CinderVolumeSource, ?> cinder;     VisitableBuilder<ObjectReference, ?> claimRef;     VisitableBuilder<FCVolumeSource, ?> fc;     VisitableBuilder<FlockerVolumeSource, ?> flocker;     VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;     VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;     VisitableBuilder<HostPathVolumeSource, ?> hostPath;     VisitableBuilder<ISCSIVolumeSource, ?> iscsi;     VisitableBuilder<NFSVolumeSource, ?> nfs;     String persistentVolumeReclaimPolicy;     VisitableBuilder<RBDVolumeSource, ?> rbd;     Map<String, Object> additionalProperties = new HashMap();
public PersistentVolumeSpecFluentImpl(){
    
}
public PersistentVolumeSpecFluentImpl( PersistentVolumeSpec instance ){
    this.withAccessModes(instance.getAccessModes()); this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); this.withCapacity(instance.getCapacity()); this.withCephfs(instance.getCephfs()); this.withCinder(instance.getCinder()); this.withClaimRef(instance.getClaimRef()); this.withFc(instance.getFc()); this.withFlocker(instance.getFlocker()); this.withGcePersistentDisk(instance.getGcePersistentDisk()); this.withGlusterfs(instance.getGlusterfs()); this.withHostPath(instance.getHostPath()); this.withIscsi(instance.getIscsi()); this.withNfs(instance.getNfs()); this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); this.withRbd(instance.getRbd()); 
}

    public T addToAccessModes( String ...items){
    for (String item : items) {this.accessModes.add(item);} return (T)this;
    }
    public T removeFromAccessModes( String ...items){
    for (String item : items) {this.accessModes.remove(item);} return (T)this;
    }
    public List<String> getAccessModes(){
    return this.accessModes;
    }
    public T withAccessModes( List<String> accessModes){
    this.accessModes.clear();if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (T) this;
    }
    public T withAccessModes( String ...accessModes){
    this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (T) this;
    }
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
    return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }
    public T withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (T) this;
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore(){
    return new AwsElasticBlockStoreNestedImpl<T>();
    }
    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item){
    return new AwsElasticBlockStoreNestedImpl<T>(item);
    }
    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore(){
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }
    public T withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID){
    return withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }
    public T addToCapacity( String key,  Quantity value){
    if(key != null && value != null) {this.capacity.put(key, value);} return (T)this;
    }
    public T addToCapacity( Map<String, Quantity> map){
    if(map != null) { this.capacity.putAll(map);} return (T)this;
    }
    public T removeFromCapacity( String key){
    if(key != null) {this.capacity.remove(key);} return (T)this;
    }
    public T removeFromCapacity( Map<String, Quantity> map){
    if(map != null) { for(Object key : map.keySet()) {this.capacity.remove(key);}} return (T)this;
    }
    public Map<String, Quantity> getCapacity(){
    return this.capacity;
    }
    public T withCapacity( Map<String, Quantity> capacity){
    this.capacity.clear();if (capacity != null) {this.capacity.putAll(capacity);} return (T) this;
    }
    public CephFSVolumeSource getCephfs(){
    return this.cephfs!=null?this.cephfs.build():null;
    }
    public T withCephfs( CephFSVolumeSource cephfs){
    if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (T) this;
    }
    public CephfsNested<T> withNewCephfs(){
    return new CephfsNestedImpl<T>();
    }
    public CephfsNested<T> withNewCephfsLike( CephFSVolumeSource item){
    return new CephfsNestedImpl<T>(item);
    }
    public CephfsNested<T> editCephfs(){
    return withNewCephfsLike(getCephfs());
    }
    public CinderVolumeSource getCinder(){
    return this.cinder!=null?this.cinder.build():null;
    }
    public T withCinder( CinderVolumeSource cinder){
    if (cinder!=null){ this.cinder= new CinderVolumeSourceBuilder(cinder); _visitables.add(this.cinder);} return (T) this;
    }
    public CinderNested<T> withNewCinder(){
    return new CinderNestedImpl<T>();
    }
    public CinderNested<T> withNewCinderLike( CinderVolumeSource item){
    return new CinderNestedImpl<T>(item);
    }
    public CinderNested<T> editCinder(){
    return withNewCinderLike(getCinder());
    }
    public T withNewCinder( String fsType,  Boolean readOnly,  String volumeID){
    return withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }
    public ObjectReference getClaimRef(){
    return this.claimRef!=null?this.claimRef.build():null;
    }
    public T withClaimRef( ObjectReference claimRef){
    if (claimRef!=null){ this.claimRef= new ObjectReferenceBuilder(claimRef); _visitables.add(this.claimRef);} return (T) this;
    }
    public ClaimRefNested<T> withNewClaimRef(){
    return new ClaimRefNestedImpl<T>();
    }
    public ClaimRefNested<T> withNewClaimRefLike( ObjectReference item){
    return new ClaimRefNestedImpl<T>(item);
    }
    public ClaimRefNested<T> editClaimRef(){
    return withNewClaimRefLike(getClaimRef());
    }
    public FCVolumeSource getFc(){
    return this.fc!=null?this.fc.build():null;
    }
    public T withFc( FCVolumeSource fc){
    if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.add(this.fc);} return (T) this;
    }
    public FcNested<T> withNewFc(){
    return new FcNestedImpl<T>();
    }
    public FcNested<T> withNewFcLike( FCVolumeSource item){
    return new FcNestedImpl<T>(item);
    }
    public FcNested<T> editFc(){
    return withNewFcLike(getFc());
    }
    public FlockerVolumeSource getFlocker(){
    return this.flocker!=null?this.flocker.build():null;
    }
    public T withFlocker( FlockerVolumeSource flocker){
    if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.add(this.flocker);} return (T) this;
    }
    public FlockerNested<T> withNewFlocker(){
    return new FlockerNestedImpl<T>();
    }
    public FlockerNested<T> withNewFlockerLike( FlockerVolumeSource item){
    return new FlockerNestedImpl<T>(item);
    }
    public FlockerNested<T> editFlocker(){
    return withNewFlockerLike(getFlocker());
    }
    public T withNewFlocker( String datasetName){
    return withFlocker(new FlockerVolumeSource(datasetName));
    }
    public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
    return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }
    public T withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk){
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (T) this;
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDisk(){
    return new GcePersistentDiskNestedImpl<T>();
    }
    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item){
    return new GcePersistentDiskNestedImpl<T>(item);
    }
    public GcePersistentDiskNested<T> editGcePersistentDisk(){
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }
    public T withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly){
    return withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }
    public GlusterfsVolumeSource getGlusterfs(){
    return this.glusterfs!=null?this.glusterfs.build():null;
    }
    public T withGlusterfs( GlusterfsVolumeSource glusterfs){
    if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (T) this;
    }
    public GlusterfsNested<T> withNewGlusterfs(){
    return new GlusterfsNestedImpl<T>();
    }
    public GlusterfsNested<T> withNewGlusterfsLike( GlusterfsVolumeSource item){
    return new GlusterfsNestedImpl<T>(item);
    }
    public GlusterfsNested<T> editGlusterfs(){
    return withNewGlusterfsLike(getGlusterfs());
    }
    public T withNewGlusterfs( String endpoints,  String path,  Boolean readOnly){
    return withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }
    public HostPathVolumeSource getHostPath(){
    return this.hostPath!=null?this.hostPath.build():null;
    }
    public T withHostPath( HostPathVolumeSource hostPath){
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (T) this;
    }
    public HostPathNested<T> withNewHostPath(){
    return new HostPathNestedImpl<T>();
    }
    public HostPathNested<T> withNewHostPathLike( HostPathVolumeSource item){
    return new HostPathNestedImpl<T>(item);
    }
    public HostPathNested<T> editHostPath(){
    return withNewHostPathLike(getHostPath());
    }
    public T withNewHostPath( String path){
    return withHostPath(new HostPathVolumeSource(path));
    }
    public ISCSIVolumeSource getIscsi(){
    return this.iscsi!=null?this.iscsi.build():null;
    }
    public T withIscsi( ISCSIVolumeSource iscsi){
    if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (T) this;
    }
    public IscsiNested<T> withNewIscsi(){
    return new IscsiNestedImpl<T>();
    }
    public IscsiNested<T> withNewIscsiLike( ISCSIVolumeSource item){
    return new IscsiNestedImpl<T>(item);
    }
    public IscsiNested<T> editIscsi(){
    return withNewIscsiLike(getIscsi());
    }
    public T withNewIscsi( String fsType,  String iqn,  Integer lun,  Boolean readOnly,  String targetPortal){
    return withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }
    public NFSVolumeSource getNfs(){
    return this.nfs!=null?this.nfs.build():null;
    }
    public T withNfs( NFSVolumeSource nfs){
    if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (T) this;
    }
    public NfsNested<T> withNewNfs(){
    return new NfsNestedImpl<T>();
    }
    public NfsNested<T> withNewNfsLike( NFSVolumeSource item){
    return new NfsNestedImpl<T>(item);
    }
    public NfsNested<T> editNfs(){
    return withNewNfsLike(getNfs());
    }
    public T withNewNfs( String path,  Boolean readOnly,  String server){
    return withNfs(new NFSVolumeSource(path, readOnly, server));
    }
    public String getPersistentVolumeReclaimPolicy(){
    return this.persistentVolumeReclaimPolicy;
    }
    public T withPersistentVolumeReclaimPolicy( String persistentVolumeReclaimPolicy){
    this.persistentVolumeReclaimPolicy=persistentVolumeReclaimPolicy; return (T) this;
    }
    public RBDVolumeSource getRbd(){
    return this.rbd!=null?this.rbd.build():null;
    }
    public T withRbd( RBDVolumeSource rbd){
    if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (T) this;
    }
    public RbdNested<T> withNewRbd(){
    return new RbdNestedImpl<T>();
    }
    public RbdNested<T> withNewRbdLike( RBDVolumeSource item){
    return new RbdNestedImpl<T>(item);
    }
    public RbdNested<T> editRbd(){
    return withNewRbdLike(getRbd());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl) o;
if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
if (claimRef != null ? !claimRef.equals(that.claimRef) :that.claimRef != null) return false;
if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
if (persistentVolumeReclaimPolicy != null ? !persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) :that.persistentVolumeReclaimPolicy != null) return false;
if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<AwsElasticBlockStoreNested<N>> implements AwsElasticBlockStoreNested<N>{

        private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
             AwsElasticBlockStoreNestedImpl (){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }
             AwsElasticBlockStoreNestedImpl ( AWSElasticBlockStoreVolumeSource item){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }
    
            public N endAwsElasticBlockStore(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(builder.build());
        }
    
}
    public class CephfsNestedImpl<N> extends CephFSVolumeSourceFluentImpl<CephfsNested<N>> implements CephfsNested<N>{

        private final CephFSVolumeSourceBuilder builder;
    
             CephfsNestedImpl ( CephFSVolumeSource item){
        this.builder = new CephFSVolumeSourceBuilder(this, item);
        }
             CephfsNestedImpl (){
        this.builder = new CephFSVolumeSourceBuilder(this);
        }
    
            public N endCephfs(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCephfs(builder.build());
        }
    
}
    public class CinderNestedImpl<N> extends CinderVolumeSourceFluentImpl<CinderNested<N>> implements CinderNested<N>{

        private final CinderVolumeSourceBuilder builder;
    
             CinderNestedImpl ( CinderVolumeSource item){
        this.builder = new CinderVolumeSourceBuilder(this, item);
        }
             CinderNestedImpl (){
        this.builder = new CinderVolumeSourceBuilder(this);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCinder(builder.build());
        }
            public N endCinder(){
            return and();
        }
    
}
    public class ClaimRefNestedImpl<N> extends ObjectReferenceFluentImpl<ClaimRefNested<N>> implements ClaimRefNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ClaimRefNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ClaimRefNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withClaimRef(builder.build());
        }
            public N endClaimRef(){
            return and();
        }
    
}
    public class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<FcNested<N>> implements FcNested<N>{

        private final FCVolumeSourceBuilder builder;
    
             FcNestedImpl (){
        this.builder = new FCVolumeSourceBuilder(this);
        }
             FcNestedImpl ( FCVolumeSource item){
        this.builder = new FCVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFc(builder.build());
        }
            public N endFc(){
            return and();
        }
    
}
    public class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<FlockerNested<N>> implements FlockerNested<N>{

        private final FlockerVolumeSourceBuilder builder;
    
             FlockerNestedImpl (){
        this.builder = new FlockerVolumeSourceBuilder(this);
        }
             FlockerNestedImpl ( FlockerVolumeSource item){
        this.builder = new FlockerVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFlocker(builder.build());
        }
            public N endFlocker(){
            return and();
        }
    
}
    public class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<GcePersistentDiskNested<N>> implements GcePersistentDiskNested<N>{

        private final GCEPersistentDiskVolumeSourceBuilder builder;
    
             GcePersistentDiskNestedImpl (){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }
             GcePersistentDiskNestedImpl ( GCEPersistentDiskVolumeSource item){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }
    
            public N endGcePersistentDisk(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(builder.build());
        }
    
}
    public class GlusterfsNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<GlusterfsNested<N>> implements GlusterfsNested<N>{

        private final GlusterfsVolumeSourceBuilder builder;
    
             GlusterfsNestedImpl (){
        this.builder = new GlusterfsVolumeSourceBuilder(this);
        }
             GlusterfsNestedImpl ( GlusterfsVolumeSource item){
        this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGlusterfs(builder.build());
        }
            public N endGlusterfs(){
            return and();
        }
    
}
    public class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<HostPathNested<N>> implements HostPathNested<N>{

        private final HostPathVolumeSourceBuilder builder;
    
             HostPathNestedImpl (){
        this.builder = new HostPathVolumeSourceBuilder(this);
        }
             HostPathNestedImpl ( HostPathVolumeSource item){
        this.builder = new HostPathVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withHostPath(builder.build());
        }
            public N endHostPath(){
            return and();
        }
    
}
    public class IscsiNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<IscsiNested<N>> implements IscsiNested<N>{

        private final ISCSIVolumeSourceBuilder builder;
    
             IscsiNestedImpl (){
        this.builder = new ISCSIVolumeSourceBuilder(this);
        }
             IscsiNestedImpl ( ISCSIVolumeSource item){
        this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withIscsi(builder.build());
        }
            public N endIscsi(){
            return and();
        }
    
}
    public class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<NfsNested<N>> implements NfsNested<N>{

        private final NFSVolumeSourceBuilder builder;
    
             NfsNestedImpl (){
        this.builder = new NFSVolumeSourceBuilder(this);
        }
             NfsNestedImpl ( NFSVolumeSource item){
        this.builder = new NFSVolumeSourceBuilder(this, item);
        }
    
            public N endNfs(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withNfs(builder.build());
        }
    
}
    public class RbdNestedImpl<N> extends RBDVolumeSourceFluentImpl<RbdNested<N>> implements RbdNested<N>{

        private final RBDVolumeSourceBuilder builder;
    
             RbdNestedImpl (){
        this.builder = new RBDVolumeSourceBuilder(this);
        }
             RbdNestedImpl ( RBDVolumeSource item){
        this.builder = new RBDVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withRbd(builder.build());
        }
            public N endRbd(){
            return and();
        }
    
}


}
