package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ConfigFluentImpl<T extends ConfigFluent<T>> extends BaseFluent<T> implements ConfigFluent<T>{

     String apiVersion;     List<VisitableBuilder<NamedCluster, ?>> clusters = new ArrayList();     List<VisitableBuilder<NamedContext, ?>> contexts = new ArrayList();     String currentContext;     List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();     String kind;     VisitableBuilder<Preferences, ?> preferences;     List<VisitableBuilder<NamedAuthInfo, ?>> users = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ConfigFluentImpl(){
    
}
public ConfigFluentImpl( Config instance ){
    this.withApiVersion(instance.getApiVersion()); this.withClusters(instance.getClusters()); this.withContexts(instance.getContexts()); this.withCurrentContext(instance.getCurrentContext()); this.withExtensions(instance.getExtensions()); this.withKind(instance.getKind()); this.withPreferences(instance.getPreferences()); this.withUsers(instance.getUsers()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToClusters( NamedCluster ...items){
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.add(builder);this.clusters.add(builder);} return (T)this;
    }
    public T removeFromClusters( NamedCluster ...items){
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.remove(builder);this.clusters.remove(builder);} return (T)this;
    }
    public List<NamedCluster> getClusters(){
    return build(clusters);
    }
    public T withClusters( List<NamedCluster> clusters){
    this.clusters.clear();if (clusters != null) {for (NamedCluster item : clusters){this.addToClusters(item);}} return (T) this;
    }
    public T withClusters( NamedCluster ...clusters){
    this.clusters.clear(); if (clusters != null) {for (NamedCluster item :clusters){ this.addToClusters(item);}} return (T) this;
    }
    public ClustersNested<T> addNewCluster(){
    return new ClustersNestedImpl<T>();
    }
    public ClustersNested<T> addNewClusterLike( NamedCluster item){
    return new ClustersNestedImpl<T>(item);
    }
    public T addToContexts( NamedContext ...items){
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.add(builder);this.contexts.add(builder);} return (T)this;
    }
    public T removeFromContexts( NamedContext ...items){
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.remove(builder);this.contexts.remove(builder);} return (T)this;
    }
    public List<NamedContext> getContexts(){
    return build(contexts);
    }
    public T withContexts( List<NamedContext> contexts){
    this.contexts.clear();if (contexts != null) {for (NamedContext item : contexts){this.addToContexts(item);}} return (T) this;
    }
    public T withContexts( NamedContext ...contexts){
    this.contexts.clear(); if (contexts != null) {for (NamedContext item :contexts){ this.addToContexts(item);}} return (T) this;
    }
    public ContextsNested<T> addNewContext(){
    return new ContextsNestedImpl<T>();
    }
    public ContextsNested<T> addNewContextLike( NamedContext item){
    return new ContextsNestedImpl<T>(item);
    }
    public String getCurrentContext(){
    return this.currentContext;
    }
    public T withCurrentContext( String currentContext){
    this.currentContext=currentContext; return (T) this;
    }
    public T addToExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (T)this;
    }
    public T removeFromExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (T)this;
    }
    public List<NamedExtension> getExtensions(){
    return build(extensions);
    }
    public T withExtensions( List<NamedExtension> extensions){
    this.extensions.clear();if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (T) this;
    }
    public T withExtensions( NamedExtension ...extensions){
    this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (T) this;
    }
    public ExtensionsNested<T> addNewExtension(){
    return new ExtensionsNestedImpl<T>();
    }
    public ExtensionsNested<T> addNewExtensionLike( NamedExtension item){
    return new ExtensionsNestedImpl<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public Preferences getPreferences(){
    return this.preferences!=null?this.preferences.build():null;
    }
    public T withPreferences( Preferences preferences){
    if (preferences!=null){ this.preferences= new PreferencesBuilder(preferences); _visitables.add(this.preferences);} return (T) this;
    }
    public PreferencesNested<T> withNewPreferences(){
    return new PreferencesNestedImpl<T>();
    }
    public PreferencesNested<T> withNewPreferencesLike( Preferences item){
    return new PreferencesNestedImpl<T>(item);
    }
    public PreferencesNested<T> editPreferences(){
    return withNewPreferencesLike(getPreferences());
    }
    public T addToUsers( NamedAuthInfo ...items){
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.add(builder);this.users.add(builder);} return (T)this;
    }
    public T removeFromUsers( NamedAuthInfo ...items){
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.remove(builder);this.users.remove(builder);} return (T)this;
    }
    public List<NamedAuthInfo> getUsers(){
    return build(users);
    }
    public T withUsers( List<NamedAuthInfo> users){
    this.users.clear();if (users != null) {for (NamedAuthInfo item : users){this.addToUsers(item);}} return (T) this;
    }
    public T withUsers( NamedAuthInfo ...users){
    this.users.clear(); if (users != null) {for (NamedAuthInfo item :users){ this.addToUsers(item);}} return (T) this;
    }
    public UsersNested<T> addNewUser(){
    return new UsersNestedImpl<T>();
    }
    public UsersNested<T> addNewUserLike( NamedAuthInfo item){
    return new UsersNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ConfigFluentImpl that = (ConfigFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (clusters != null ? !clusters.equals(that.clusters) :that.clusters != null) return false;
if (contexts != null ? !contexts.equals(that.contexts) :that.contexts != null) return false;
if (currentContext != null ? !currentContext.equals(that.currentContext) :that.currentContext != null) return false;
if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (preferences != null ? !preferences.equals(that.preferences) :that.preferences != null) return false;
if (users != null ? !users.equals(that.users) :that.users != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ClustersNestedImpl<N> extends NamedClusterFluentImpl<ClustersNested<N>> implements ClustersNested<N>{

        private final NamedClusterBuilder builder;
    
             ClustersNestedImpl (){
        this.builder = new NamedClusterBuilder(this);
        }
             ClustersNestedImpl ( NamedCluster item){
        this.builder = new NamedClusterBuilder(this, item);
        }
    
            public N endCluster(){
            return and();
        }
            public N and(){
            return (N) ConfigFluentImpl.this.addToClusters(builder.build());
        }
    
}
    public class ContextsNestedImpl<N> extends NamedContextFluentImpl<ContextsNested<N>> implements ContextsNested<N>{

        private final NamedContextBuilder builder;
    
             ContextsNestedImpl (){
        this.builder = new NamedContextBuilder(this);
        }
             ContextsNestedImpl ( NamedContext item){
        this.builder = new NamedContextBuilder(this, item);
        }
    
            public N endContext(){
            return and();
        }
            public N and(){
            return (N) ConfigFluentImpl.this.addToContexts(builder.build());
        }
    
}
    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ExtensionsNested<N>> implements ExtensionsNested<N>{

        private final NamedExtensionBuilder builder;
    
             ExtensionsNestedImpl ( NamedExtension item){
        this.builder = new NamedExtensionBuilder(this, item);
        }
             ExtensionsNestedImpl (){
        this.builder = new NamedExtensionBuilder(this);
        }
    
            public N and(){
            return (N) ConfigFluentImpl.this.addToExtensions(builder.build());
        }
            public N endExtension(){
            return and();
        }
    
}
    public class PreferencesNestedImpl<N> extends PreferencesFluentImpl<PreferencesNested<N>> implements PreferencesNested<N>{

        private final PreferencesBuilder builder;
    
             PreferencesNestedImpl (){
        this.builder = new PreferencesBuilder(this);
        }
             PreferencesNestedImpl ( Preferences item){
        this.builder = new PreferencesBuilder(this, item);
        }
    
            public N and(){
            return (N) ConfigFluentImpl.this.withPreferences(builder.build());
        }
            public N endPreferences(){
            return and();
        }
    
}
    public class UsersNestedImpl<N> extends NamedAuthInfoFluentImpl<UsersNested<N>> implements UsersNested<N>{

        private final NamedAuthInfoBuilder builder;
    
             UsersNestedImpl (){
        this.builder = new NamedAuthInfoBuilder(this);
        }
             UsersNestedImpl ( NamedAuthInfo item){
        this.builder = new NamedAuthInfoBuilder(this, item);
        }
    
            public N and(){
            return (N) ConfigFluentImpl.this.addToUsers(builder.build());
        }
            public N endUser(){
            return and();
        }
    
}


}
