package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ResourceQuotaFluentImpl<T extends ResourceQuotaFluent<T>> extends BaseFluent<T> implements ResourceQuotaFluent<T>{

     ResourceQuota.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<ResourceQuotaSpec, ?> spec;     VisitableBuilder<ResourceQuotaStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();
public ResourceQuotaFluentImpl(){
    
}
public ResourceQuotaFluentImpl( ResourceQuota instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); this.withStatus(instance.getStatus()); 
}

    public ResourceQuota.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ResourceQuota.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public ResourceQuotaSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( ResourceQuotaSpec spec){
    if (spec!=null){ this.spec= new ResourceQuotaSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNestedImpl<T>();
    }
    public SpecNested<T> withNewSpecLike( ResourceQuotaSpec item){
    return new SpecNestedImpl<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public ResourceQuotaStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( ResourceQuotaStatus status){
    if (status!=null){ this.status= new ResourceQuotaStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNestedImpl<T>();
    }
    public StatusNested<T> withNewStatusLike( ResourceQuotaStatus item){
    return new StatusNestedImpl<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ResourceQuotaFluentImpl that = (ResourceQuotaFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) ResourceQuotaFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNestedImpl<N> extends ResourceQuotaSpecFluentImpl<SpecNested<N>> implements SpecNested<N>{

        private final ResourceQuotaSpecBuilder builder;
    
             SpecNestedImpl (){
        this.builder = new ResourceQuotaSpecBuilder(this);
        }
             SpecNestedImpl ( ResourceQuotaSpec item){
        this.builder = new ResourceQuotaSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) ResourceQuotaFluentImpl.this.withSpec(builder.build());
        }
    
}
    public class StatusNestedImpl<N> extends ResourceQuotaStatusFluentImpl<StatusNested<N>> implements StatusNested<N>{

        private final ResourceQuotaStatusBuilder builder;
    
             StatusNestedImpl (){
        this.builder = new ResourceQuotaStatusBuilder(this);
        }
             StatusNestedImpl ( ResourceQuotaStatus item){
        this.builder = new ResourceQuotaStatusBuilder(this, item);
        }
    
            public N and(){
            return (N) ResourceQuotaFluentImpl.this.withStatus(builder.build());
        }
            public N endStatus(){
            return and();
        }
    
}


}
