package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ListMetaFluentImpl<T extends ListMetaFluent<T>> extends BaseFluent<T> implements ListMetaFluent<T>{

     String resourceVersion;     String selfLink;     Map<String, Object> additionalProperties = new HashMap();
public ListMetaFluentImpl(){
    
}
public ListMetaFluentImpl( ListMeta instance ){
    this.withResourceVersion(instance.getResourceVersion()); this.withSelfLink(instance.getSelfLink()); 
}

    public String getResourceVersion(){
    return this.resourceVersion;
    }
    public T withResourceVersion( String resourceVersion){
    this.resourceVersion=resourceVersion; return (T) this;
    }
    public String getSelfLink(){
    return this.selfLink;
    }
    public T withSelfLink( String selfLink){
    this.selfLink=selfLink; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ListMetaFluentImpl that = (ListMetaFluentImpl) o;
if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
if (selfLink != null ? !selfLink.equals(that.selfLink) :that.selfLink != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
