package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface StatusFluent<T extends StatusFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public Integer getCode();    public T withCode( Integer code);    public StatusDetails getDetails();    public T withDetails( StatusDetails details);    public DetailsNested<T> withNewDetails();    public DetailsNested<T> withNewDetailsLike( StatusDetails item);    public DetailsNested<T> editDetails();    public String getKind();    public T withKind( String kind);    public String getMessage();    public T withMessage( String message);    public ListMeta getMetadata();    public T withMetadata( ListMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ListMeta item);    public MetadataNested<T> editMetadata();    public T withNewMetadata( String resourceVersion,  String selfLink);    public String getReason();    public T withReason( String reason);    public String getStatus();    public T withStatus( String status);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface DetailsNested<N> extends Nested<N>, StatusDetailsFluent<DetailsNested<N>>{
            public N and();            public N endDetails();        
}

    public interface MetadataNested<N> extends Nested<N>, ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
