package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DownwardAPIVolumeSourceFluentImpl<T extends DownwardAPIVolumeSourceFluent<T>> extends BaseFluent<T> implements DownwardAPIVolumeSourceFluent<T>{

     List<VisitableBuilder<DownwardAPIVolumeFile, ?>> items = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public DownwardAPIVolumeSourceFluentImpl(){
    
}
public DownwardAPIVolumeSourceFluentImpl( DownwardAPIVolumeSource instance ){
    this.withItems(instance.getItems()); 
}

    public T addToItems( DownwardAPIVolumeFile ...items){
    for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public T removeFromItems( DownwardAPIVolumeFile ...items){
    for (DownwardAPIVolumeFile item : items) {DownwardAPIVolumeFileBuilder builder = new DownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (T)this;
    }
    public List<DownwardAPIVolumeFile> getItems(){
    return build(items);
    }
    public T withItems( List<DownwardAPIVolumeFile> items){
    this.items.clear();if (items != null) {for (DownwardAPIVolumeFile item : items){this.addToItems(item);}} return (T) this;
    }
    public T withItems( DownwardAPIVolumeFile ...items){
    this.items.clear(); if (items != null) {for (DownwardAPIVolumeFile item :items){ this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNestedImpl<T>();
    }
    public ItemsNested<T> addNewItemLike( DownwardAPIVolumeFile item){
    return new ItemsNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DownwardAPIVolumeSourceFluentImpl that = (DownwardAPIVolumeSourceFluentImpl) o;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ItemsNestedImpl<N> extends DownwardAPIVolumeFileFluentImpl<ItemsNested<N>> implements ItemsNested<N>{

        private final DownwardAPIVolumeFileBuilder builder;
    
             ItemsNestedImpl ( DownwardAPIVolumeFile item){
        this.builder = new DownwardAPIVolumeFileBuilder(this, item);
        }
             ItemsNestedImpl (){
        this.builder = new DownwardAPIVolumeFileBuilder(this);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) DownwardAPIVolumeSourceFluentImpl.this.addToItems(builder.build());
        }
    
}


}
