
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "cancelled",
    "completionTimestamp",
    "config",
    "duration",
    "message",
    "outputDockerImageReference",
    "phase",
    "reason",
    "startTimestamp"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class BuildStatus {

    /**
     * describes if a cancel event was triggered for the build
     * 
     */
    @JsonProperty("cancelled")
    private Boolean cancelled;
    /**
     * server time when the pod running this build stopped running
     * 
     */
    @JsonProperty("completionTimestamp")
    private String completionTimestamp;
    /**
     * 
     * 
     */
    @JsonProperty("config")
    @Valid
    private ObjectReference config;
    /**
     * amount of time the build has been running
     * 
     */
    @JsonProperty("duration")
    private Long duration;
    /**
     * human-readable message indicating details about why the build has this status
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * reference to the Docker image built by this build
     * 
     */
    @JsonProperty("outputDockerImageReference")
    private String outputDockerImageReference;
    /**
     * observed point in the build lifecycle
     * 
     */
    @JsonProperty("phase")
    private String phase;
    /**
     * brief CamelCase string describing a failure
     * 
     */
    @JsonProperty("reason")
    private String reason;
    /**
     * server time when this build started running in a pod
     * 
     */
    @JsonProperty("startTimestamp")
    private String startTimestamp;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuildStatus() {
    }

    /**
     * 
     * @param duration
     * @param phase
     * @param reason
     * @param completionTimestamp
     * @param cancelled
     * @param message
     * @param config
     * @param outputDockerImageReference
     * @param startTimestamp
     */
    public BuildStatus(Boolean cancelled, String completionTimestamp, ObjectReference config, Long duration, String message, String outputDockerImageReference, String phase, String reason, String startTimestamp) {
        this.cancelled = cancelled;
        this.completionTimestamp = completionTimestamp;
        this.config = config;
        this.duration = duration;
        this.message = message;
        this.outputDockerImageReference = outputDockerImageReference;
        this.phase = phase;
        this.reason = reason;
        this.startTimestamp = startTimestamp;
    }

    /**
     * describes if a cancel event was triggered for the build
     * 
     * @return
     *     The cancelled
     */
    @JsonProperty("cancelled")
    public Boolean getCancelled() {
        return cancelled;
    }

    /**
     * describes if a cancel event was triggered for the build
     * 
     * @param cancelled
     *     The cancelled
     */
    @JsonProperty("cancelled")
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    /**
     * server time when the pod running this build stopped running
     * 
     * @return
     *     The completionTimestamp
     */
    @JsonProperty("completionTimestamp")
    public String getCompletionTimestamp() {
        return completionTimestamp;
    }

    /**
     * server time when the pod running this build stopped running
     * 
     * @param completionTimestamp
     *     The completionTimestamp
     */
    @JsonProperty("completionTimestamp")
    public void setCompletionTimestamp(String completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
    }

    /**
     * 
     * 
     * @return
     *     The config
     */
    @JsonProperty("config")
    public ObjectReference getConfig() {
        return config;
    }

    /**
     * 
     * 
     * @param config
     *     The config
     */
    @JsonProperty("config")
    public void setConfig(ObjectReference config) {
        this.config = config;
    }

    /**
     * amount of time the build has been running
     * 
     * @return
     *     The duration
     */
    @JsonProperty("duration")
    public Long getDuration() {
        return duration;
    }

    /**
     * amount of time the build has been running
     * 
     * @param duration
     *     The duration
     */
    @JsonProperty("duration")
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    /**
     * human-readable message indicating details about why the build has this status
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * human-readable message indicating details about why the build has this status
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * reference to the Docker image built by this build
     * 
     * @return
     *     The outputDockerImageReference
     */
    @JsonProperty("outputDockerImageReference")
    public String getOutputDockerImageReference() {
        return outputDockerImageReference;
    }

    /**
     * reference to the Docker image built by this build
     * 
     * @param outputDockerImageReference
     *     The outputDockerImageReference
     */
    @JsonProperty("outputDockerImageReference")
    public void setOutputDockerImageReference(String outputDockerImageReference) {
        this.outputDockerImageReference = outputDockerImageReference;
    }

    /**
     * observed point in the build lifecycle
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public String getPhase() {
        return phase;
    }

    /**
     * observed point in the build lifecycle
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(String phase) {
        this.phase = phase;
    }

    /**
     * brief CamelCase string describing a failure
     * 
     * @return
     *     The reason
     */
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    /**
     * brief CamelCase string describing a failure
     * 
     * @param reason
     *     The reason
     */
    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * server time when this build started running in a pod
     * 
     * @return
     *     The startTimestamp
     */
    @JsonProperty("startTimestamp")
    public String getStartTimestamp() {
        return startTimestamp;
    }

    /**
     * server time when this build started running in a pod
     * 
     * @param startTimestamp
     *     The startTimestamp
     */
    @JsonProperty("startTimestamp")
    public void setStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
