package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ClusterRoleBindingFluentImpl<T extends ClusterRoleBindingFluent<T>> extends BaseFluent<T> implements ClusterRoleBindingFluent<T>{

     ClusterRoleBinding.ApiVersion apiVersion;     List<String> groupNames = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<ObjectReference, ?> roleRef;     List<VisitableBuilder<ObjectReference, ?>> subjects = new ArrayList();     List<String> userNames = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ClusterRoleBindingFluentImpl(){
    
}
public ClusterRoleBindingFluentImpl( ClusterRoleBinding instance ){
    this.withApiVersion(instance.getApiVersion()); this.withGroupNames(instance.getGroupNames()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRoleRef(instance.getRoleRef()); this.withSubjects(instance.getSubjects()); this.withUserNames(instance.getUserNames()); 
}

    public ClusterRoleBinding.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ClusterRoleBinding.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToGroupNames( String ...items){
    for (String item : items) {this.groupNames.add(item);} return (T)this;
    }
    public T removeFromGroupNames( String ...items){
    for (String item : items) {this.groupNames.remove(item);} return (T)this;
    }
    public List<String> getGroupNames(){
    return this.groupNames;
    }
    public T withGroupNames( List<String> groupNames){
    this.groupNames.clear();if (groupNames != null) {for (String item : groupNames){this.addToGroupNames(item);}} return (T) this;
    }
    public T withGroupNames( String ...groupNames){
    this.groupNames.clear(); if (groupNames != null) {for (String item :groupNames){ this.addToGroupNames(item);}} return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public ObjectReference getRoleRef(){
    return this.roleRef!=null?this.roleRef.build():null;
    }
    public T withRoleRef( ObjectReference roleRef){
    if (roleRef!=null){ this.roleRef= new ObjectReferenceBuilder(roleRef); _visitables.add(this.roleRef);} return (T) this;
    }
    public RoleRefNested<T> withNewRoleRef(){
    return new RoleRefNestedImpl<T>();
    }
    public RoleRefNested<T> withNewRoleRefLike( ObjectReference item){
    return new RoleRefNestedImpl<T>(item);
    }
    public RoleRefNested<T> editRoleRef(){
    return withNewRoleRefLike(getRoleRef());
    }
    public T addToSubjects( ObjectReference ...items){
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.add(builder);this.subjects.add(builder);} return (T)this;
    }
    public T removeFromSubjects( ObjectReference ...items){
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.remove(builder);this.subjects.remove(builder);} return (T)this;
    }
    public List<ObjectReference> getSubjects(){
    return build(subjects);
    }
    public T withSubjects( List<ObjectReference> subjects){
    this.subjects.clear();if (subjects != null) {for (ObjectReference item : subjects){this.addToSubjects(item);}} return (T) this;
    }
    public T withSubjects( ObjectReference ...subjects){
    this.subjects.clear(); if (subjects != null) {for (ObjectReference item :subjects){ this.addToSubjects(item);}} return (T) this;
    }
    public SubjectsNested<T> addNewSubject(){
    return new SubjectsNestedImpl<T>();
    }
    public SubjectsNested<T> addNewSubjectLike( ObjectReference item){
    return new SubjectsNestedImpl<T>(item);
    }
    public T addToUserNames( String ...items){
    for (String item : items) {this.userNames.add(item);} return (T)this;
    }
    public T removeFromUserNames( String ...items){
    for (String item : items) {this.userNames.remove(item);} return (T)this;
    }
    public List<String> getUserNames(){
    return this.userNames;
    }
    public T withUserNames( List<String> userNames){
    this.userNames.clear();if (userNames != null) {for (String item : userNames){this.addToUserNames(item);}} return (T) this;
    }
    public T withUserNames( String ...userNames){
    this.userNames.clear(); if (userNames != null) {for (String item :userNames){ this.addToUserNames(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ClusterRoleBindingFluentImpl that = (ClusterRoleBindingFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (groupNames != null ? !groupNames.equals(that.groupNames) :that.groupNames != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
if (userNames != null ? !userNames.equals(that.userNames) :that.userNames != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) ClusterRoleBindingFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RoleRefNestedImpl<N> extends ObjectReferenceFluentImpl<RoleRefNested<N>> implements RoleRefNested<N>{

        private final ObjectReferenceBuilder builder;
    
             RoleRefNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             RoleRefNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N endRoleRef(){
            return and();
        }
            public N and(){
            return (N) ClusterRoleBindingFluentImpl.this.withRoleRef(builder.build());
        }
    
}
    public class SubjectsNestedImpl<N> extends ObjectReferenceFluentImpl<SubjectsNested<N>> implements SubjectsNested<N>{

        private final ObjectReferenceBuilder builder;
    
             SubjectsNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             SubjectsNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) ClusterRoleBindingFluentImpl.this.addToSubjects(builder.build());
        }
            public N endSubject(){
            return and();
        }
    
}


}
