package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.List;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface CustomBuildStrategyFluent<T extends CustomBuildStrategyFluent<T>> extends Fluent<T>{


    public String getBuildAPIVersion();    public T withBuildAPIVersion( String buildAPIVersion);    public T addToEnv( EnvVar ...items);    public T removeFromEnv( EnvVar ...items);    public List<EnvVar> getEnv();    public T withEnv( List<EnvVar> env);    public T withEnv( EnvVar ...env);    public EnvNested<T> addNewEnv();    public EnvNested<T> addNewEnvLike( EnvVar item);    public Boolean isExposeDockerSocket();    public T withExposeDockerSocket( Boolean exposeDockerSocket);    public Boolean isForcePull();    public T withForcePull( Boolean forcePull);    public ObjectReference getFrom();    public T withFrom( ObjectReference from);    public FromNested<T> withNewFrom();    public FromNested<T> withNewFromLike( ObjectReference item);    public FromNested<T> editFrom();    public LocalObjectReference getPullSecret();    public T withPullSecret( LocalObjectReference pullSecret);    public PullSecretNested<T> withNewPullSecret();    public PullSecretNested<T> withNewPullSecretLike( LocalObjectReference item);    public PullSecretNested<T> editPullSecret();    public T withNewPullSecret( String name);    public T addToSecrets( SecretSpec ...items);    public T removeFromSecrets( SecretSpec ...items);    public List<SecretSpec> getSecrets();    public T withSecrets( List<SecretSpec> secrets);    public T withSecrets( SecretSpec ...secrets);    public SecretsNested<T> addNewSecret();    public SecretsNested<T> addNewSecretLike( SecretSpec item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface EnvNested<N> extends Nested<N>, EnvVarFluent<EnvNested<N>>{
            public N endEnv();            public N and();        
}

    public interface FromNested<N> extends Nested<N>, ObjectReferenceFluent<FromNested<N>>{
            public N endFrom();            public N and();        
}

    public interface PullSecretNested<N> extends Nested<N>, LocalObjectReferenceFluent<PullSecretNested<N>>{
            public N and();            public N endPullSecret();        
}

    public interface SecretsNested<N> extends Nested<N>, SecretSpecFluent<SecretsNested<N>>{
            public N and();            public N endSecret();        
}


}
