package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ImageLayerFluentImpl<T extends ImageLayerFluent<T>> extends BaseFluent<T> implements ImageLayerFluent<T>{

     String name;     Long size;     Map<String, Object> additionalProperties = new HashMap();
public ImageLayerFluentImpl(){
    
}
public ImageLayerFluentImpl( ImageLayer instance ){
    this.withName(instance.getName()); this.withSize(instance.getSize()); 
}

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Long getSize(){
    return this.size;
    }
    public T withSize( Long size){
    this.size=size; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageLayerFluentImpl that = (ImageLayerFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (size != null ? !size.equals(that.size) :that.size != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
