package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public interface SecretBuildSourceFluent<T extends SecretBuildSourceFluent<T>> extends Fluent<T>{


    public String getDestinationDir();    public T withDestinationDir( String destinationDir);    public LocalObjectReference getSecret();    public T withSecret( LocalObjectReference secret);    public SecretNested<T> withNewSecret();    public SecretNested<T> withNewSecretLike( LocalObjectReference item);    public SecretNested<T> editSecret();    public T withNewSecret( String name);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SecretNested<N> extends Nested<N>, LocalObjectReferenceFluent<SecretNested<N>>{
            public N and();            public N endSecret();        
}


}
