/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodSpecFluentImpl<T extends PodSpecFluent<T>>
extends BaseFluent<T>
implements PodSpecFluent<T> {
    Long activeDeadlineSeconds;
    List<VisitableBuilder<Container, ?>> containers = new ArrayList();
    String dnsPolicy;
    String host;
    Boolean hostIPC;
    Boolean hostNetwork;
    Boolean hostPID;
    List<VisitableBuilder<LocalObjectReference, ?>> imagePullSecrets = new ArrayList();
    String nodeName;
    Map<String, String> nodeSelector = new HashMap<String, String>();
    String restartPolicy;
    VisitableBuilder<PodSecurityContext, ?> securityContext;
    String serviceAccount;
    String serviceAccountName;
    Long terminationGracePeriodSeconds;
    List<VisitableBuilder<Volume, ?>> volumes = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PodSpecFluentImpl() {
    }

    public PodSpecFluentImpl(PodSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withContainers(instance.getContainers());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withHost(instance.getHost());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public T withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (T)this;
    }

    @Override
    public T addToContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.add(builder);
            this.containers.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.remove(builder);
            this.containers.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<Container> getContainers() {
        return this.build(this.containers);
    }

    @Override
    public T withContainers(List<Container> containers) {
        this.containers.clear();
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withContainers(Container ... containers) {
        this.containers.clear();
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (T)this;
    }

    @Override
    public PodSpecFluent.ContainersNested<T> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.ContainersNested<T> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(item);
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public T withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (T)this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public T withHost(String host) {
        this.host = host;
        return (T)this;
    }

    @Override
    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    @Override
    public T withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (T)this;
    }

    @Override
    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public T withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (T)this;
    }

    @Override
    public Boolean isHostPID() {
        return this.hostPID;
    }

    @Override
    public T withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (T)this;
    }

    @Override
    public T addToImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.build(this.imagePullSecrets);
    }

    @Override
    public T withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.imagePullSecrets.clear();
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (T)this;
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<T> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<T> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(item);
    }

    @Override
    public T addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public T withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (T)this;
    }

    @Override
    public T addToNodeSelector(String key, String value) {
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToNodeSelector(Map<String, String> map) {
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromNodeSelector(String key) {
        if (key != null) {
            this.nodeSelector.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromNodeSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.nodeSelector.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public T withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector.clear();
        if (nodeSelector != null) {
            this.nodeSelector.putAll(nodeSelector);
        }
        return (T)this;
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public T withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (T)this;
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext != null ? (PodSecurityContext)this.securityContext.build() : null;
    }

    @Override
    public T withSecurityContext(PodSecurityContext securityContext) {
        if (securityContext != null) {
            this.securityContext = new PodSecurityContextBuilder(securityContext);
            this._visitables.add(this.securityContext);
        }
        return (T)this;
    }

    @Override
    public PodSpecFluent.SecurityContextNested<T> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public PodSpecFluent.SecurityContextNested<T> withNewSecurityContextLike(PodSecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public PodSpecFluent.SecurityContextNested<T> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public T withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (T)this;
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public T withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (T)this;
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public T withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (T)this;
    }

    @Override
    public T addToVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.add(builder);
            this.volumes.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.remove(builder);
            this.volumes.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.build(this.volumes);
    }

    @Override
    public T withVolumes(List<Volume> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withVolumes(Volume ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (T)this;
    }

    @Override
    public PodSpecFluent.VolumesNested<T> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public PodSpecFluent.VolumesNested<T> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSpecFluentImpl that = (PodSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>>
    implements PodSpecFluent.VolumesNested<N> {
        private final VolumeBuilder builder;

        VolumesNestedImpl() {
            this.builder = new VolumeBuilder(this);
        }

        VolumesNestedImpl(Volume item) {
            this.builder = new VolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.addToVolumes(this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class SecurityContextNestedImpl<N>
    extends PodSecurityContextFluentImpl<PodSpecFluent.SecurityContextNested<N>>
    implements PodSpecFluent.SecurityContextNested<N> {
        private final PodSecurityContextBuilder builder;

        SecurityContextNestedImpl() {
            this.builder = new PodSecurityContextBuilder(this);
        }

        SecurityContextNestedImpl(PodSecurityContext item) {
            this.builder = new PodSecurityContextBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<PodSpecFluent.ImagePullSecretsNested<N>>
    implements PodSpecFluent.ImagePullSecretsNested<N> {
        private final LocalObjectReferenceBuilder builder;

        ImagePullSecretsNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        ImagePullSecretsNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.addToImagePullSecrets(this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>>
    implements PodSpecFluent.ContainersNested<N> {
        private final ContainerBuilder builder;

        ContainersNestedImpl(Container item) {
            this.builder = new ContainerBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.addToContainers(this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

