/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilization;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationBuilder;
import io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReference;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceBuilder;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class HorizontalPodAutoscalerSpecFluentImpl<T extends HorizontalPodAutoscalerSpecFluent<T>>
extends BaseFluent<T>
implements HorizontalPodAutoscalerSpecFluent<T> {
    VisitableBuilder<CPUTargetUtilization, ?> cpuUtilization;
    Integer maxReplicas;
    Integer minReplicas;
    VisitableBuilder<SubresourceReference, ?> scaleRef;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public HorizontalPodAutoscalerSpecFluentImpl(HorizontalPodAutoscalerSpec instance) {
        this.withCpuUtilization(instance.getCpuUtilization());
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleRef(instance.getScaleRef());
    }

    @Override
    public CPUTargetUtilization getCpuUtilization() {
        return this.cpuUtilization != null ? (CPUTargetUtilization)this.cpuUtilization.build() : null;
    }

    @Override
    public T withCpuUtilization(CPUTargetUtilization cpuUtilization) {
        if (cpuUtilization != null) {
            this.cpuUtilization = new CPUTargetUtilizationBuilder(cpuUtilization);
            this._visitables.add(this.cpuUtilization);
        }
        return (T)this;
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<T> withNewCpuUtilization() {
        return new CpuUtilizationNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<T> withNewCpuUtilizationLike(CPUTargetUtilization item) {
        return new CpuUtilizationNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<T> editCpuUtilization() {
        return this.withNewCpuUtilizationLike(this.getCpuUtilization());
    }

    @Override
    public T withNewCpuUtilization(Integer targetPercentage) {
        return this.withCpuUtilization(new CPUTargetUtilization(targetPercentage));
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public T withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (T)this;
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public T withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (T)this;
    }

    @Override
    public SubresourceReference getScaleRef() {
        return this.scaleRef != null ? (SubresourceReference)this.scaleRef.build() : null;
    }

    @Override
    public T withScaleRef(SubresourceReference scaleRef) {
        if (scaleRef != null) {
            this.scaleRef = new SubresourceReferenceBuilder(scaleRef);
            this._visitables.add(this.scaleRef);
        }
        return (T)this;
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<T> withNewScaleRef() {
        return new ScaleRefNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<T> withNewScaleRefLike(SubresourceReference item) {
        return new ScaleRefNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleRefNested<T> editScaleRef() {
        return this.withNewScaleRefLike(this.getScaleRef());
    }

    @Override
    public T withNewScaleRef(String apiVersion, String kind, String name, String subresource) {
        return this.withScaleRef(new SubresourceReference(apiVersion, kind, name, subresource));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.cpuUtilization != null ? !this.cpuUtilization.equals(that.cpuUtilization) : that.cpuUtilization != null) {
            return false;
        }
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        if (this.scaleRef != null ? !this.scaleRef.equals(that.scaleRef) : that.scaleRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ScaleRefNestedImpl<N>
    extends SubresourceReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleRefNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.ScaleRefNested<N> {
        private final SubresourceReferenceBuilder builder;

        ScaleRefNestedImpl(SubresourceReference item) {
            this.builder = new SubresourceReferenceBuilder(this, item);
        }

        ScaleRefNestedImpl() {
            this.builder = new SubresourceReferenceBuilder(this);
        }

        @Override
        public N endScaleRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withScaleRef(this.builder.build());
        }
    }

    public class CpuUtilizationNestedImpl<N>
    extends CPUTargetUtilizationFluentImpl<HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.CpuUtilizationNested<N> {
        private final CPUTargetUtilizationBuilder builder;

        CpuUtilizationNestedImpl() {
            this.builder = new CPUTargetUtilizationBuilder(this);
        }

        CpuUtilizationNestedImpl(CPUTargetUtilization item) {
            this.builder = new CPUTargetUtilizationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withCpuUtilization(this.builder.build());
        }

        @Override
        public N endCpuUtilization() {
            return this.and();
        }
    }
}

