/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterRoleBindingFluentImpl<T extends ClusterRoleBindingFluent<T>>
extends BaseFluent<T>
implements ClusterRoleBindingFluent<T> {
    ClusterRoleBinding.ApiVersion apiVersion;
    List<String> groupNames = new ArrayList<String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ObjectReference, ?> roleRef;
    List<VisitableBuilder<ObjectReference, ?>> subjects = new ArrayList();
    List<String> userNames = new ArrayList<String>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ClusterRoleBindingFluentImpl() {
    }

    public ClusterRoleBindingFluentImpl(ClusterRoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
    }

    @Override
    public ClusterRoleBinding.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(ClusterRoleBinding.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public T addToGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public T withGroupNames(List<String> groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withGroupNames(String ... groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ObjectReference getRoleRef() {
        return this.roleRef != null ? (ObjectReference)this.roleRef.build() : null;
    }

    @Override
    public T withRoleRef(ObjectReference roleRef) {
        if (roleRef != null) {
            this.roleRef = new ObjectReferenceBuilder(roleRef);
            this._visitables.add(this.roleRef);
        }
        return (T)this;
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<T> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<T> withNewRoleRefLike(ObjectReference item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<T> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public T addToSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.subjects.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ObjectReference> getSubjects() {
        return this.build(this.subjects);
    }

    @Override
    public T withSubjects(List<ObjectReference> subjects) {
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withSubjects(ObjectReference ... subjects) {
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (T)this;
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<T> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<T> addNewSubjectLike(ObjectReference item) {
        return new SubjectsNestedImpl(item);
    }

    @Override
    public T addToUserNames(String ... items) {
        for (String item : items) {
            this.userNames.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromUserNames(String ... items) {
        for (String item : items) {
            this.userNames.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getUserNames() {
        return this.userNames;
    }

    @Override
    public T withUserNames(List<String> userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withUserNames(String ... userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRoleBindingFluentImpl that = (ClusterRoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupNames != null ? !this.groupNames.equals(that.groupNames) : that.groupNames != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        if (this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null) {
            return false;
        }
        if (this.userNames != null ? !this.userNames.equals(that.userNames) : that.userNames != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SubjectsNestedImpl<N>
    extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.SubjectsNested<N>>
    implements ClusterRoleBindingFluent.SubjectsNested<N> {
        private final ObjectReferenceBuilder builder;

        SubjectsNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        SubjectsNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.addToSubjects(this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<ClusterRoleBindingFluent.RoleRefNested<N>>
    implements ClusterRoleBindingFluent.RoleRefNested<N> {
        private final ObjectReferenceBuilder builder;

        RoleRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterRoleBindingFluent.MetadataNested<N>>
    implements ClusterRoleBindingFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

