/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.api.model.ContainerImageFluent;
import io.fabric8.kubernetes.api.model.ContainerImageFluentImpl;
import io.fabric8.kubernetes.api.model.EditableContainerImage;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerImageBuilder
extends ContainerImageFluentImpl<ContainerImageBuilder>
implements VisitableBuilder<ContainerImage, ContainerImageBuilder> {
    ContainerImageFluent<?> fluent;

    public ContainerImageBuilder() {
        this(new ContainerImage());
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent) {
        this(fluent, new ContainerImage());
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance) {
        this.fluent = fluent;
        fluent.withRepoTags(instance.getRepoTags());
        fluent.withSize(instance.getSize());
    }

    public ContainerImageBuilder(ContainerImage instance) {
        this.fluent = this;
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
    }

    @Override
    public EditableContainerImage build() {
        EditableContainerImage buildable = new EditableContainerImage(this.fluent.getRepoTags(), this.fluent.getSize());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerImageBuilder that = (ContainerImageBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

