package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecurityContextConstraintsFluent<T extends SecurityContextConstraintsFluent<T>> extends Fluent<T>{


    public Boolean isAllowHostDirVolumePlugin();    public T withAllowHostDirVolumePlugin( Boolean allowHostDirVolumePlugin);    public Boolean isAllowHostIPC();    public T withAllowHostIPC( Boolean allowHostIPC);    public Boolean isAllowHostNetwork();    public T withAllowHostNetwork( Boolean allowHostNetwork);    public Boolean isAllowHostPID();    public T withAllowHostPID( Boolean allowHostPID);    public Boolean isAllowHostPorts();    public T withAllowHostPorts( Boolean allowHostPorts);    public Boolean isAllowPrivilegedContainer();    public T withAllowPrivilegedContainer( Boolean allowPrivilegedContainer);    public T addToAllowedCapabilities( String ...items);    public T removeFromAllowedCapabilities( String ...items);    public List<String> getAllowedCapabilities();    public T withAllowedCapabilities( List<String> allowedCapabilities);    public T withAllowedCapabilities( String ...allowedCapabilities);    public String getApiVersion();    public T withApiVersion( String apiVersion);    public T addToDefaultAddCapabilities( String ...items);    public T removeFromDefaultAddCapabilities( String ...items);    public List<String> getDefaultAddCapabilities();    public T withDefaultAddCapabilities( List<String> defaultAddCapabilities);    public T withDefaultAddCapabilities( String ...defaultAddCapabilities);    public FSGroupStrategyOptions getFsGroup();    public T withFsGroup( FSGroupStrategyOptions fsGroup);    public FsGroupNested<T> withNewFsGroup();    public FsGroupNested<T> withNewFsGroupLike( FSGroupStrategyOptions item);    public FsGroupNested<T> editFsGroup();    public T addToGroups( String ...items);    public T removeFromGroups( String ...items);    public List<String> getGroups();    public T withGroups( List<String> groups);    public T withGroups( String ...groups);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public Integer getPriority();    public T withPriority( Integer priority);    public T addToRequiredDropCapabilities( String ...items);    public T removeFromRequiredDropCapabilities( String ...items);    public List<String> getRequiredDropCapabilities();    public T withRequiredDropCapabilities( List<String> requiredDropCapabilities);    public T withRequiredDropCapabilities( String ...requiredDropCapabilities);    public RunAsUserStrategyOptions getRunAsUser();    public T withRunAsUser( RunAsUserStrategyOptions runAsUser);    public RunAsUserNested<T> withNewRunAsUser();    public RunAsUserNested<T> withNewRunAsUserLike( RunAsUserStrategyOptions item);    public RunAsUserNested<T> editRunAsUser();    public T withNewRunAsUser( String type,  Long uid,  Long uidRangeMax,  Long uidRangeMin);    public SELinuxContextStrategyOptions getSeLinuxContext();    public T withSeLinuxContext( SELinuxContextStrategyOptions seLinuxContext);    public SeLinuxContextNested<T> withNewSeLinuxContext();    public SeLinuxContextNested<T> withNewSeLinuxContextLike( SELinuxContextStrategyOptions item);    public SeLinuxContextNested<T> editSeLinuxContext();    public SupplementalGroupsStrategyOptions getSupplementalGroups();    public T withSupplementalGroups( SupplementalGroupsStrategyOptions supplementalGroups);    public SupplementalGroupsNested<T> withNewSupplementalGroups();    public SupplementalGroupsNested<T> withNewSupplementalGroupsLike( SupplementalGroupsStrategyOptions item);    public SupplementalGroupsNested<T> editSupplementalGroups();    public T addToUsers( String ...items);    public T removeFromUsers( String ...items);    public List<String> getUsers();    public T withUsers( List<String> users);    public T withUsers( String ...users);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface FsGroupNested<N> extends Nested<N>, FSGroupStrategyOptionsFluent<FsGroupNested<N>>{
            public N and();            public N endFsGroup();        
}

    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface RunAsUserNested<N> extends Nested<N>, RunAsUserStrategyOptionsFluent<RunAsUserNested<N>>{
            public N endRunAsUser();            public N and();        
}

    public interface SeLinuxContextNested<N> extends Nested<N>, SELinuxContextStrategyOptionsFluent<SeLinuxContextNested<N>>{
            public N and();            public N endSeLinuxContext();        
}

    public interface SupplementalGroupsNested<N> extends Nested<N>, SupplementalGroupsStrategyOptionsFluent<SupplementalGroupsNested<N>>{
            public N and();            public N endSupplementalGroups();        
}


}
