package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class CinderVolumeSourceBuilder extends CinderVolumeSourceFluentImpl<CinderVolumeSourceBuilder> implements VisitableBuilder<CinderVolumeSource,CinderVolumeSourceBuilder>{

     CinderVolumeSourceFluent<?> fluent;
public CinderVolumeSourceBuilder(){
    this(new CinderVolumeSource());
}
public CinderVolumeSourceBuilder( CinderVolumeSourceFluent<?> fluent ){
    this(fluent, new CinderVolumeSource());
}
public CinderVolumeSourceBuilder( CinderVolumeSourceFluent<?> fluent , CinderVolumeSource instance ){
    this.fluent = fluent; fluent.withFsType(instance.getFsType()); fluent.withReadOnly(instance.getReadOnly()); fluent.withVolumeID(instance.getVolumeID()); 
}
public CinderVolumeSourceBuilder( CinderVolumeSource instance ){
    this.fluent = this; this.withFsType(instance.getFsType()); this.withReadOnly(instance.getReadOnly()); this.withVolumeID(instance.getVolumeID()); 
}

public EditableCinderVolumeSource build(){
    EditableCinderVolumeSource buildable = new EditableCinderVolumeSource(fluent.getFsType(),fluent.isReadOnly(),fluent.getVolumeID());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CinderVolumeSourceBuilder that = (CinderVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
