package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;

public interface BuildConfigSpecFluent<T extends BuildConfigSpecFluent<T>> extends Fluent<T>{


    public Long getCompletionDeadlineSeconds();    public T withCompletionDeadlineSeconds( Long completionDeadlineSeconds);    public BuildOutput getOutput();    public T withOutput( BuildOutput output);    public OutputNested<T> withNewOutput();    public OutputNested<T> withNewOutputLike( BuildOutput item);    public OutputNested<T> editOutput();    public BuildPostCommitSpec getPostCommit();    public T withPostCommit( BuildPostCommitSpec postCommit);    public PostCommitNested<T> withNewPostCommit();    public PostCommitNested<T> withNewPostCommitLike( BuildPostCommitSpec item);    public PostCommitNested<T> editPostCommit();    public ResourceRequirements getResources();    public T withResources( ResourceRequirements resources);    public ResourcesNested<T> withNewResources();    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<T> editResources();    public SourceRevision getRevision();    public T withRevision( SourceRevision revision);    public RevisionNested<T> withNewRevision();    public RevisionNested<T> withNewRevisionLike( SourceRevision item);    public RevisionNested<T> editRevision();    public String getServiceAccount();    public T withServiceAccount( String serviceAccount);    public BuildSource getSource();    public T withSource( BuildSource source);    public SourceNested<T> withNewSource();    public SourceNested<T> withNewSourceLike( BuildSource item);    public SourceNested<T> editSource();    public BuildStrategy getStrategy();    public T withStrategy( BuildStrategy strategy);    public StrategyNested<T> withNewStrategy();    public StrategyNested<T> withNewStrategyLike( BuildStrategy item);    public StrategyNested<T> editStrategy();    public T addToTriggers( BuildTriggerPolicy ...items);    public T removeFromTriggers( BuildTriggerPolicy ...items);    public List<BuildTriggerPolicy> getTriggers();    public T withTriggers( List<BuildTriggerPolicy> triggers);    public T withTriggers( BuildTriggerPolicy ...triggers);    public TriggersNested<T> addNewTrigger();    public TriggersNested<T> addNewTriggerLike( BuildTriggerPolicy item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface OutputNested<N> extends Nested<N>, BuildOutputFluent<OutputNested<N>>{
            public N endOutput();            public N and();        
}

    public interface PostCommitNested<N> extends Nested<N>, BuildPostCommitSpecFluent<PostCommitNested<N>>{
            public N and();            public N endPostCommit();        
}

    public interface ResourcesNested<N> extends Nested<N>, ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface RevisionNested<N> extends Nested<N>, SourceRevisionFluent<RevisionNested<N>>{
            public N endRevision();            public N and();        
}

    public interface SourceNested<N> extends Nested<N>, BuildSourceFluent<SourceNested<N>>{
            public N and();            public N endSource();        
}

    public interface StrategyNested<N> extends Nested<N>, BuildStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}

    public interface TriggersNested<N> extends Nested<N>, BuildTriggerPolicyFluent<TriggersNested<N>>{
            public N endTrigger();            public N and();        
}


}
