package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class RouteIngressConditionFluentImpl<T extends RouteIngressConditionFluent<T>> extends BaseFluent<T> implements RouteIngressConditionFluent<T>{

     String lastTransitionTime;     String message;     String reason;     String status;     String type;     Map<String, Object> additionalProperties = new HashMap();
public RouteIngressConditionFluentImpl(){
    
}
public RouteIngressConditionFluentImpl( RouteIngressCondition instance ){
    this.withLastTransitionTime(instance.getLastTransitionTime()); this.withMessage(instance.getMessage()); this.withReason(instance.getReason()); this.withStatus(instance.getStatus()); this.withType(instance.getType()); 
}

    public String getLastTransitionTime(){
    return this.lastTransitionTime;
    }
    public T withLastTransitionTime( String lastTransitionTime){
    this.lastTransitionTime=lastTransitionTime; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public String getReason(){
    return this.reason;
    }
    public T withReason( String reason){
    this.reason=reason; return (T) this;
    }
    public String getStatus(){
    return this.status;
    }
    public T withStatus( String status){
    this.status=status; return (T) this;
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RouteIngressConditionFluentImpl that = (RouteIngressConditionFluentImpl) o;
if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
