/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder;

import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Visitor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BaseFluent<T>
implements Fluent<T>,
Visitable<T> {
    public final List<Visitable> _visitables = new ArrayList<Visitable>();

    public <T> ArrayList<T> build(List<? extends Builder<T>> list) {
        ArrayList<T> r = new ArrayList<T>();
        for (Builder<T> b : list) {
            r.add(b.build());
        }
        return r;
    }

    public <T> LinkedHashSet<T> build(LinkedHashSet<? extends Builder<T>> set) {
        LinkedHashSet r = new LinkedHashSet();
        for (Builder builder : set) {
            r.add(builder.build());
        }
        return r;
    }

    public <T> ArrayList<T> aggregate(List<? extends T> ... lists) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (List<? extends T> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    public <T> LinkedHashSet<T> aggregate(Set<? extends T> ... sets) {
        LinkedHashSet<? extends T> result = new LinkedHashSet<T>();
        for (Set<? extends T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    @Override
    public T accept(Visitor visitor) {
        for (Visitable v : this._visitables) {
            v.accept(visitor);
        }
        try {
            visitor.visit(this);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return (T)this;
    }
}

