/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableLoadBalancerStatus;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LoadBalancerStatusBuilder
extends LoadBalancerStatusFluentImpl<LoadBalancerStatusBuilder>
implements VisitableBuilder<LoadBalancerStatus, LoadBalancerStatusBuilder> {
    LoadBalancerStatusFluent<?> fluent;

    public LoadBalancerStatusBuilder() {
        this(new LoadBalancerStatus());
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent) {
        this(fluent, new LoadBalancerStatus());
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent, LoadBalancerStatus instance) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
    }

    public LoadBalancerStatusBuilder(LoadBalancerStatus instance) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
    }

    @Override
    public EditableLoadBalancerStatus build() {
        EditableLoadBalancerStatus buildable = new EditableLoadBalancerStatus(this.fluent.getIngress());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadBalancerStatusBuilder that = (LoadBalancerStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

