package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class SubjectAccessReviewBuilder extends SubjectAccessReviewFluentImpl<SubjectAccessReviewBuilder> implements VisitableBuilder<SubjectAccessReview,SubjectAccessReviewBuilder>{

     SubjectAccessReviewFluent<?> fluent;
public SubjectAccessReviewBuilder(){
    this(new SubjectAccessReview());
}
public SubjectAccessReviewBuilder( SubjectAccessReviewFluent<?> fluent ){
    this(fluent, new SubjectAccessReview());
}
public SubjectAccessReviewBuilder( SubjectAccessReviewFluent<?> fluent , SubjectAccessReview instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withContent(instance.getContent()); fluent.withGroups(instance.getGroups()); fluent.withKind(instance.getKind()); fluent.withNamespace(instance.getNamespace()); fluent.withResource(instance.getResource()); fluent.withResourceAPIGroup(instance.getResourceAPIGroup()); fluent.withResourceAPIVersion(instance.getResourceAPIVersion()); fluent.withResourceName(instance.getResourceName()); fluent.withUser(instance.getUser()); fluent.withVerb(instance.getVerb()); 
}
public SubjectAccessReviewBuilder( SubjectAccessReview instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withContent(instance.getContent()); this.withGroups(instance.getGroups()); this.withKind(instance.getKind()); this.withNamespace(instance.getNamespace()); this.withResource(instance.getResource()); this.withResourceAPIGroup(instance.getResourceAPIGroup()); this.withResourceAPIVersion(instance.getResourceAPIVersion()); this.withResourceName(instance.getResourceName()); this.withUser(instance.getUser()); this.withVerb(instance.getVerb()); 
}

public EditableSubjectAccessReview build(){
    EditableSubjectAccessReview buildable = new EditableSubjectAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getGroups(),fluent.getKind(),fluent.getNamespace(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getUser(),fluent.getVerb());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SubjectAccessReviewBuilder that = (SubjectAccessReviewBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
