package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import java.util.List;
import java.util.List;

public class BuildSourceFluentImpl<T extends BuildSourceFluent<T>> extends BaseFluent<T> implements BuildSourceFluent<T>{

     VisitableBuilder<BinaryBuildSource, ?> binary;     String contextDir;     String dockerfile;     VisitableBuilder<GitBuildSource, ?> git;     List<VisitableBuilder<ImageSource, ?>> images = new ArrayList();     List<VisitableBuilder<SecretBuildSource, ?>> secrets = new ArrayList();     VisitableBuilder<LocalObjectReference, ?> sourceSecret;     String type;     Map<String, Object> additionalProperties = new HashMap();
public BuildSourceFluentImpl(){
    
}
public BuildSourceFluentImpl( BuildSource instance ){
    this.withBinary(instance.getBinary()); this.withContextDir(instance.getContextDir()); this.withDockerfile(instance.getDockerfile()); this.withGit(instance.getGit()); this.withImages(instance.getImages()); this.withSecrets(instance.getSecrets()); this.withSourceSecret(instance.getSourceSecret()); this.withType(instance.getType()); 
}

    public BinaryBuildSource getBinary(){
    return this.binary!=null?this.binary.build():null;
    }
    public T withBinary( BinaryBuildSource binary){
    if (binary!=null){ this.binary= new BinaryBuildSourceBuilder(binary); _visitables.add(this.binary);} return (T) this;
    }
    public BinaryNested<T> withNewBinary(){
    return new BinaryNestedImpl<T>();
    }
    public BinaryNested<T> withNewBinaryLike( BinaryBuildSource item){
    return new BinaryNestedImpl<T>(item);
    }
    public BinaryNested<T> editBinary(){
    return withNewBinaryLike(getBinary());
    }
    public T withNewBinary( String asFile){
    return withBinary(new BinaryBuildSource(asFile));
    }
    public String getContextDir(){
    return this.contextDir;
    }
    public T withContextDir( String contextDir){
    this.contextDir=contextDir; return (T) this;
    }
    public String getDockerfile(){
    return this.dockerfile;
    }
    public T withDockerfile( String dockerfile){
    this.dockerfile=dockerfile; return (T) this;
    }
    public GitBuildSource getGit(){
    return this.git!=null?this.git.build():null;
    }
    public T withGit( GitBuildSource git){
    if (git!=null){ this.git= new GitBuildSourceBuilder(git); _visitables.add(this.git);} return (T) this;
    }
    public GitNested<T> withNewGit(){
    return new GitNestedImpl<T>();
    }
    public GitNested<T> withNewGitLike( GitBuildSource item){
    return new GitNestedImpl<T>(item);
    }
    public GitNested<T> editGit(){
    return withNewGitLike(getGit());
    }
    public T withNewGit( String httpProxy,  String httpsProxy,  String ref,  String uri){
    return withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }
    public T addToImages( ImageSource ...items){
    for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.add(builder);this.images.add(builder);} return (T)this;
    }
    public T removeFromImages( ImageSource ...items){
    for (ImageSource item : items) {ImageSourceBuilder builder = new ImageSourceBuilder(item);_visitables.remove(builder);this.images.remove(builder);} return (T)this;
    }
    public List<ImageSource> getImages(){
    return build(images);
    }
    public T withImages( List<ImageSource> images){
    this.images.clear();if (images != null) {for (ImageSource item : images){this.addToImages(item);}} return (T) this;
    }
    public T withImages( ImageSource ...images){
    this.images.clear(); if (images != null) {for (ImageSource item :images){ this.addToImages(item);}} return (T) this;
    }
    public ImagesNested<T> addNewImage(){
    return new ImagesNestedImpl<T>();
    }
    public ImagesNested<T> addNewImageLike( ImageSource item){
    return new ImagesNestedImpl<T>(item);
    }
    public T addToSecrets( SecretBuildSource ...items){
    for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.add(builder);this.secrets.add(builder);} return (T)this;
    }
    public T removeFromSecrets( SecretBuildSource ...items){
    for (SecretBuildSource item : items) {SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);_visitables.remove(builder);this.secrets.remove(builder);} return (T)this;
    }
    public List<SecretBuildSource> getSecrets(){
    return build(secrets);
    }
    public T withSecrets( List<SecretBuildSource> secrets){
    this.secrets.clear();if (secrets != null) {for (SecretBuildSource item : secrets){this.addToSecrets(item);}} return (T) this;
    }
    public T withSecrets( SecretBuildSource ...secrets){
    this.secrets.clear(); if (secrets != null) {for (SecretBuildSource item :secrets){ this.addToSecrets(item);}} return (T) this;
    }
    public SecretsNested<T> addNewSecret(){
    return new SecretsNestedImpl<T>();
    }
    public SecretsNested<T> addNewSecretLike( SecretBuildSource item){
    return new SecretsNestedImpl<T>(item);
    }
    public LocalObjectReference getSourceSecret(){
    return this.sourceSecret!=null?this.sourceSecret.build():null;
    }
    public T withSourceSecret( LocalObjectReference sourceSecret){
    if (sourceSecret!=null){ this.sourceSecret= new LocalObjectReferenceBuilder(sourceSecret); _visitables.add(this.sourceSecret);} return (T) this;
    }
    public SourceSecretNested<T> withNewSourceSecret(){
    return new SourceSecretNestedImpl<T>();
    }
    public SourceSecretNested<T> withNewSourceSecretLike( LocalObjectReference item){
    return new SourceSecretNestedImpl<T>(item);
    }
    public SourceSecretNested<T> editSourceSecret(){
    return withNewSourceSecretLike(getSourceSecret());
    }
    public T withNewSourceSecret( String name){
    return withSourceSecret(new LocalObjectReference(name));
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildSourceFluentImpl that = (BuildSourceFluentImpl) o;
if (binary != null ? !binary.equals(that.binary) :that.binary != null) return false;
if (contextDir != null ? !contextDir.equals(that.contextDir) :that.contextDir != null) return false;
if (dockerfile != null ? !dockerfile.equals(that.dockerfile) :that.dockerfile != null) return false;
if (git != null ? !git.equals(that.git) :that.git != null) return false;
if (images != null ? !images.equals(that.images) :that.images != null) return false;
if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
if (sourceSecret != null ? !sourceSecret.equals(that.sourceSecret) :that.sourceSecret != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class BinaryNestedImpl<N> extends BinaryBuildSourceFluentImpl<BinaryNested<N>> implements BinaryNested<N>{

        private final BinaryBuildSourceBuilder builder;
    
             BinaryNestedImpl (){
        this.builder = new BinaryBuildSourceBuilder(this);
        }
             BinaryNestedImpl ( BinaryBuildSource item){
        this.builder = new BinaryBuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildSourceFluentImpl.this.withBinary(builder.build());
        }
            public N endBinary(){
            return and();
        }
    
}
    public class GitNestedImpl<N> extends GitBuildSourceFluentImpl<GitNested<N>> implements GitNested<N>{

        private final GitBuildSourceBuilder builder;
    
             GitNestedImpl ( GitBuildSource item){
        this.builder = new GitBuildSourceBuilder(this, item);
        }
             GitNestedImpl (){
        this.builder = new GitBuildSourceBuilder(this);
        }
    
            public N and(){
            return (N) BuildSourceFluentImpl.this.withGit(builder.build());
        }
            public N endGit(){
            return and();
        }
    
}
    public class ImagesNestedImpl<N> extends ImageSourceFluentImpl<ImagesNested<N>> implements ImagesNested<N>{

        private final ImageSourceBuilder builder;
    
             ImagesNestedImpl ( ImageSource item){
        this.builder = new ImageSourceBuilder(this, item);
        }
             ImagesNestedImpl (){
        this.builder = new ImageSourceBuilder(this);
        }
    
            public N and(){
            return (N) BuildSourceFluentImpl.this.addToImages(builder.build());
        }
            public N endImage(){
            return and();
        }
    
}
    public class SecretsNestedImpl<N> extends SecretBuildSourceFluentImpl<SecretsNested<N>> implements SecretsNested<N>{

        private final SecretBuildSourceBuilder builder;
    
             SecretsNestedImpl (){
        this.builder = new SecretBuildSourceBuilder(this);
        }
             SecretsNestedImpl ( SecretBuildSource item){
        this.builder = new SecretBuildSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildSourceFluentImpl.this.addToSecrets(builder.build());
        }
            public N endSecret(){
            return and();
        }
    
}
    public class SourceSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SourceSecretNested<N>> implements SourceSecretNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SourceSecretNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             SourceSecretNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildSourceFluentImpl.this.withSourceSecret(builder.build());
        }
            public N endSourceSecret(){
            return and();
        }
    
}


}
