/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableTCPSocketAction;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.kubernetes.api.model.TCPSocketActionFluent;
import io.fabric8.kubernetes.api.model.TCPSocketActionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TCPSocketActionBuilder
extends TCPSocketActionFluentImpl<TCPSocketActionBuilder>
implements VisitableBuilder<TCPSocketAction, TCPSocketActionBuilder> {
    TCPSocketActionFluent<?> fluent;

    public TCPSocketActionBuilder() {
        this(new TCPSocketAction());
    }

    public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent) {
        this(fluent, new TCPSocketAction());
    }

    public TCPSocketActionBuilder(TCPSocketActionFluent<?> fluent, TCPSocketAction instance) {
        this.fluent = fluent;
        fluent.withPort(instance.getPort());
    }

    public TCPSocketActionBuilder(TCPSocketAction instance) {
        this.fluent = this;
        this.withPort(instance.getPort());
    }

    @Override
    public EditableTCPSocketAction build() {
        EditableTCPSocketAction buildable = new EditableTCPSocketAction(this.fluent.getPort());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCPSocketActionBuilder that = (TCPSocketActionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

