package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class LifecycleHookBuilder extends LifecycleHookFluentImpl<LifecycleHookBuilder> implements VisitableBuilder<LifecycleHook,LifecycleHookBuilder>{

     LifecycleHookFluent<?> fluent;
public LifecycleHookBuilder(){
    this(new LifecycleHook());
}
public LifecycleHookBuilder( LifecycleHookFluent<?> fluent ){
    this(fluent, new LifecycleHook());
}
public LifecycleHookBuilder( LifecycleHookFluent<?> fluent , LifecycleHook instance ){
    this.fluent = fluent; fluent.withExecNewPod(instance.getExecNewPod()); fluent.withFailurePolicy(instance.getFailurePolicy()); fluent.withTagImages(instance.getTagImages()); 
}
public LifecycleHookBuilder( LifecycleHook instance ){
    this.fluent = this; this.withExecNewPod(instance.getExecNewPod()); this.withFailurePolicy(instance.getFailurePolicy()); this.withTagImages(instance.getTagImages()); 
}

public EditableLifecycleHook build(){
    EditableLifecycleHook buildable = new EditableLifecycleHook(fluent.getExecNewPod(),fluent.getFailurePolicy(),fluent.getTagImages());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
LifecycleHookBuilder that = (LifecycleHookBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
