/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableFlexVolumeSource;
import io.fabric8.kubernetes.api.model.FlexVolumeSource;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class FlexVolumeSourceBuilder
extends FlexVolumeSourceFluentImpl<FlexVolumeSourceBuilder>
implements VisitableBuilder<FlexVolumeSource, FlexVolumeSourceBuilder> {
    FlexVolumeSourceFluent<?> fluent;

    public FlexVolumeSourceBuilder() {
        this(new FlexVolumeSource());
    }

    public FlexVolumeSourceBuilder(FlexVolumeSourceFluent<?> fluent) {
        this(fluent, new FlexVolumeSource());
    }

    public FlexVolumeSourceBuilder(FlexVolumeSourceFluent<?> fluent, FlexVolumeSource instance) {
        this.fluent = fluent;
        fluent.withDriver(instance.getDriver());
        fluent.withFsType(instance.getFsType());
        fluent.withOptions(instance.getOptions());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withSecretRef(instance.getSecretRef());
    }

    public FlexVolumeSourceBuilder(FlexVolumeSource instance) {
        this.fluent = this;
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withOptions(instance.getOptions());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
    }

    @Override
    public EditableFlexVolumeSource build() {
        EditableFlexVolumeSource buildable = new EditableFlexVolumeSource(this.fluent.getDriver(), this.fluent.getFsType(), this.fluent.getOptions(), this.fluent.isReadOnly(), this.fluent.getSecretRef());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlexVolumeSourceBuilder that = (FlexVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

