/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class ReplicaSetFluentImpl<T extends ReplicaSetFluent<T>>
extends BaseFluent<T>
implements ReplicaSetFluent<T> {
    String apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ReplicaSetSpec, ?> spec;
    VisitableBuilder<ReplicaSetStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ReplicaSetFluentImpl() {
    }

    public ReplicaSetFluentImpl(ReplicaSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public ReplicaSetFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ReplicaSetFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ReplicaSetFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ReplicaSetSpec getSpec() {
        return this.spec != null ? (ReplicaSetSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(ReplicaSetSpec spec) {
        if (spec != null) {
            this.spec = new ReplicaSetSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public ReplicaSetFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ReplicaSetFluent.SpecNested<T> withNewSpecLike(ReplicaSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ReplicaSetFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ReplicaSetStatus getStatus() {
        return this.status != null ? (ReplicaSetStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(ReplicaSetStatus status) {
        if (status != null) {
            this.status = new ReplicaSetStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public ReplicaSetFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ReplicaSetFluent.StatusNested<T> withNewStatusLike(ReplicaSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ReplicaSetFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T withNewStatus(Integer fullyLabeledReplicas, Long observedGeneration, Integer replicas) {
        return this.withStatus(new ReplicaSetStatus(fullyLabeledReplicas, observedGeneration, replicas));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaSetFluentImpl that = (ReplicaSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends ReplicaSetStatusFluentImpl<ReplicaSetFluent.StatusNested<N>>
    implements ReplicaSetFluent.StatusNested<N> {
        private final ReplicaSetStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new ReplicaSetStatusBuilder(this);
        }

        StatusNestedImpl(ReplicaSetStatus item) {
            this.builder = new ReplicaSetStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ReplicaSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ReplicaSetSpecFluentImpl<ReplicaSetFluent.SpecNested<N>>
    implements ReplicaSetFluent.SpecNested<N> {
        private final ReplicaSetSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new ReplicaSetSpecBuilder(this);
        }

        SpecNestedImpl(ReplicaSetSpec item) {
            this.builder = new ReplicaSetSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ReplicaSetFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ReplicaSetFluent.MetadataNested<N>>
    implements ReplicaSetFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicaSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

