package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EndpointSubsetFluent<T extends EndpointSubsetFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<VisitableBuilder<EndpointAddress, ?>> addresses = new ArrayList();     List<VisitableBuilder<EndpointPort, ?>> ports = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public T addToAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (T)this;
    }
    public List<EndpointAddress> getAddresses(){
    return build(addresses);
    }
    public T withAddresses( List<EndpointAddress> addresses){
    this.addresses.clear();if (addresses != null) {for (EndpointAddress item : addresses){this.addToAddresses(item);}} return (T) this;
    }
    public T withAddresses( EndpointAddress ...addresses){
    this.addresses.clear(); if (addresses != null) {for (EndpointAddress item :addresses){ this.addToAddresses(item);}} return (T) this;
    }
    public AddressesNested<T> addNewAddresse(){
    return new AddressesNested<T>();
    }
    public AddressesNested<T> addNewAddresseLike( EndpointAddress item){
    return new AddressesNested<T>(item);
    }
    public T addToPorts( EndpointPort ...items){
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (T)this;
    }
    public List<EndpointPort> getPorts(){
    return build(ports);
    }
    public T withPorts( List<EndpointPort> ports){
    this.ports.clear();if (ports != null) {for (EndpointPort item : ports){this.addToPorts(item);}} return (T) this;
    }
    public T withPorts( EndpointPort ...ports){
    this.ports.clear(); if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (T) this;
    }
    public PortsNested<T> addNewPort(){
    return new PortsNested<T>();
    }
    public PortsNested<T> addNewPortLike( EndpointPort item){
    return new PortsNested<T>(item);
    }
    public T addNewPort( String name,  Integer port,  String protocol){
    return addToPorts(new EndpointPort(name, port, protocol));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class AddressesNested<N> extends EndpointAddressFluent<AddressesNested<N>> implements Nested<N>{

        private final EndpointAddressBuilder builder;
    
             AddressesNested (){
        this.builder = new EndpointAddressBuilder(this);
        }
             AddressesNested ( EndpointAddress item){
        this.builder = new EndpointAddressBuilder(this, item);
        }
    
            public N and(){
            return (N) EndpointSubsetFluent.this.addToAddresses(builder.build());
        }
            public N endAddresse(){
            return and();
        }
    
}
    public class PortsNested<N> extends EndpointPortFluent<PortsNested<N>> implements Nested<N>{

        private final EndpointPortBuilder builder;
    
             PortsNested (){
        this.builder = new EndpointPortBuilder(this);
        }
             PortsNested ( EndpointPort item){
        this.builder = new EndpointPortBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) EndpointSubsetFluent.this.addToPorts(builder.build());
        }
    
}


}
