package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ExecNewPodHookFluent<T extends ExecNewPodHookFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<String> command = new ArrayList();     String containerName;     List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();

    public T addToCommand( String ...items){
    for (String item : items) {this.command.add(item);} return (T)this;
    }
    public List<String> getCommand(){
    return this.command;
    }
    public T withCommand( List<String> command){
    this.command.clear();if (command != null) {for (String item : command){this.addToCommand(item);}} return (T) this;
    }
    public T withCommand( String ...command){
    this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (T) this;
    }
    public String getContainerName(){
    return this.containerName;
    }
    public T withContainerName( String containerName){
    this.containerName=containerName; return (T) this;
    }
    public T addToEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (T)this;
    }
    public List<EnvVar> getEnv(){
    return build(env);
    }
    public T withEnv( List<EnvVar> env){
    this.env.clear();if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (T) this;
    }
    public T withEnv( EnvVar ...env){
    this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (T) this;
    }
    public EnvNested<T> addNewEnv(){
    return new EnvNested<T>();
    }
    public EnvNested<T> addNewEnvLike( EnvVar item){
    return new EnvNested<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class EnvNested<N> extends EnvVarFluent<EnvNested<N>> implements Nested<N>{

        private final EnvVarBuilder builder;
    
             EnvNested (){
        this.builder = new EnvVarBuilder(this);
        }
             EnvNested ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
    
            public N endEnv(){
            return and();
        }
            public N and(){
            return (N) ExecNewPodHookFluent.this.addToEnv(builder.build());
        }
    
}


}
