
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "name",
    "value",
    "valueFrom"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class EnvVar {

    /**
     * name of the environment variable; must be a C_IDENTIFIER
     * 
     */
    @JsonProperty("name")
    @Pattern(regexp = "^[A-Za-z_][A-Za-z0-9_]*$")
    private String name;
    /**
     * value of the environment variable; defaults to empty string; variable references $(VAR_NAME) are expanded using the previously defined environment varibles in the container and any service environment variables; if a variable cannot be resolved
     * 
     */
    @JsonProperty("value")
    private String value;
    /**
     * 
     * 
     */
    @JsonProperty("valueFrom")
    @Valid
    private EnvVarSource valueFrom;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public EnvVar() {
    }

    /**
     * 
     * @param valueFrom
     * @param name
     * @param value
     */
    public EnvVar(String name, String value, EnvVarSource valueFrom) {
        this.name = name;
        this.value = value;
        this.valueFrom = valueFrom;
    }

    /**
     * name of the environment variable; must be a C_IDENTIFIER
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * name of the environment variable; must be a C_IDENTIFIER
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * value of the environment variable; defaults to empty string; variable references $(VAR_NAME) are expanded using the previously defined environment varibles in the container and any service environment variables; if a variable cannot be resolved
     * 
     * @return
     *     The value
     */
    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    /**
     * value of the environment variable; defaults to empty string; variable references $(VAR_NAME) are expanded using the previously defined environment varibles in the container and any service environment variables; if a variable cannot be resolved
     * 
     * @param value
     *     The value
     */
    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 
     * 
     * @return
     *     The valueFrom
     */
    @JsonProperty("valueFrom")
    public EnvVarSource getValueFrom() {
        return valueFrom;
    }

    /**
     * 
     * 
     * @param valueFrom
     *     The valueFrom
     */
    @JsonProperty("valueFrom")
    public void setValueFrom(EnvVarSource valueFrom) {
        this.valueFrom = valueFrom;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
