package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PodListBuilder extends PodListFluent<PodListBuilder> implements VisitableBuilder<PodList,PodListBuilder>{

     PodListFluent<?> fluent;
public PodListBuilder(){
    this(new PodList());
}
public PodListBuilder( PodListFluent<?> fluent ){
    this(fluent, new PodList());
}
public PodListBuilder( PodListFluent<?> fluent , PodList instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withItems(instance.getItems()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); 
}
public PodListBuilder( PodList instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withItems(instance.getItems()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

public EditablePodList build(){
    EditablePodList buildable = new EditablePodList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    