package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class SecurityContextFluent<T extends SecurityContextFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<Capabilities, ?> capabilities;     Boolean privileged;     Boolean runAsNonRoot;     Long runAsUser;     SELinuxOptions seLinuxOptions;     Map<String, Object> additionalProperties = new HashMap();

    public Capabilities getCapabilities(){
    return this.capabilities!=null?this.capabilities.build():null;
    }
    public T withCapabilities( Capabilities capabilities){
    if (capabilities!=null){ this.capabilities= new CapabilitiesBuilder(capabilities); _visitables.add(this.capabilities);} return (T) this;
    }
    public CapabilitiesNested<T> withNewCapabilities(){
    return new CapabilitiesNested<T>();
    }
    public CapabilitiesNested<T> withNewCapabilitiesLike( Capabilities item){
    return new CapabilitiesNested<T>(item);
    }
    public CapabilitiesNested<T> editCapabilities(){
    return withNewCapabilitiesLike(getCapabilities());
    }
    public Boolean isPrivileged(){
    return this.privileged;
    }
    public T withPrivileged( Boolean privileged){
    this.privileged=privileged; return (T) this;
    }
    public Boolean isRunAsNonRoot(){
    return this.runAsNonRoot;
    }
    public T withRunAsNonRoot( Boolean runAsNonRoot){
    this.runAsNonRoot=runAsNonRoot; return (T) this;
    }
    public Long getRunAsUser(){
    return this.runAsUser;
    }
    public T withRunAsUser( Long runAsUser){
    this.runAsUser=runAsUser; return (T) this;
    }
    public SELinuxOptions getSeLinuxOptions(){
    return this.seLinuxOptions;
    }
    public T withSeLinuxOptions( SELinuxOptions seLinuxOptions){
    this.seLinuxOptions=seLinuxOptions; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class CapabilitiesNested<N> extends CapabilitiesFluent<CapabilitiesNested<N>> implements Nested<N>{

        private final CapabilitiesBuilder builder;
    
             CapabilitiesNested (){
        this.builder = new CapabilitiesBuilder(this);
        }
             CapabilitiesNested ( Capabilities item){
        this.builder = new CapabilitiesBuilder(this, item);
        }
    
            public N endCapabilities(){
            return and();
        }
            public N and(){
            return (N) SecurityContextFluent.this.withCapabilities(builder.build());
        }
    
}


}
