
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "clusterIP",
    "deprecatedPublicIPs",
    "portalIP",
    "ports",
    "selector",
    "sessionAffinity",
    "type"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
public class ServiceSpec {

    /**
     * IP address of the service; usually assigned by the system; if specified
     * 
     */
    @JsonProperty("clusterIP")
    private java.lang.String clusterIP;
    /**
     * deprecated. externally visible IPs (e.g. load balancers) that should be proxied to this service
     * 
     */
    @JsonProperty("deprecatedPublicIPs")
    @Valid
    private List<java.lang.String> deprecatedPublicIPs = new ArrayList<java.lang.String>();
    /**
     * deprecated
     * 
     */
    @JsonProperty("portalIP")
    private java.lang.String portalIP;
    /**
     * ports exposed by the service; see http://releases.k8s.io/v1.0.0/docs/services.md#virtual-ips-and-service-proxies
     * 
     */
    @JsonProperty("ports")
    @Valid
    private List<ServicePort> ports = new ArrayList<ServicePort>();
    /**
     * label keys and values that must match in order to receive traffic for this service; if empty
     * 
     */
    @JsonProperty("selector")
    @Valid
    private Map<String, String> selector;
    /**
     * enable client IP based session affinity; must be ClientIP or None; defaults to None; see http://releases.k8s.io/v1.0.0/docs/services.md#virtual-ips-and-service-proxies
     * 
     */
    @JsonProperty("sessionAffinity")
    private java.lang.String sessionAffinity;
    /**
     * type of this service; must be ClusterIP
     * 
     */
    @JsonProperty("type")
    private java.lang.String type;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceSpec() {
    }

    /**
     * 
     * @param selector
     * @param ports
     * @param portalIP
     * @param sessionAffinity
     * @param clusterIP
     * @param deprecatedPublicIPs
     * @param type
     */
    public ServiceSpec(java.lang.String clusterIP, List<java.lang.String> deprecatedPublicIPs, java.lang.String portalIP, List<ServicePort> ports, Map<String, String> selector, java.lang.String sessionAffinity, java.lang.String type) {
        this.clusterIP = clusterIP;
        this.deprecatedPublicIPs = deprecatedPublicIPs;
        this.portalIP = portalIP;
        this.ports = ports;
        this.selector = selector;
        this.sessionAffinity = sessionAffinity;
        this.type = type;
    }

    /**
     * IP address of the service; usually assigned by the system; if specified
     * 
     * @return
     *     The clusterIP
     */
    @JsonProperty("clusterIP")
    public java.lang.String getClusterIP() {
        return clusterIP;
    }

    /**
     * IP address of the service; usually assigned by the system; if specified
     * 
     * @param clusterIP
     *     The clusterIP
     */
    @JsonProperty("clusterIP")
    public void setClusterIP(java.lang.String clusterIP) {
        this.clusterIP = clusterIP;
    }

    /**
     * deprecated. externally visible IPs (e.g. load balancers) that should be proxied to this service
     * 
     * @return
     *     The deprecatedPublicIPs
     */
    @JsonProperty("deprecatedPublicIPs")
    public List<java.lang.String> getDeprecatedPublicIPs() {
        return deprecatedPublicIPs;
    }

    /**
     * deprecated. externally visible IPs (e.g. load balancers) that should be proxied to this service
     * 
     * @param deprecatedPublicIPs
     *     The deprecatedPublicIPs
     */
    @JsonProperty("deprecatedPublicIPs")
    public void setDeprecatedPublicIPs(List<java.lang.String> deprecatedPublicIPs) {
        this.deprecatedPublicIPs = deprecatedPublicIPs;
    }

    /**
     * deprecated
     * 
     * @return
     *     The portalIP
     */
    @JsonProperty("portalIP")
    public java.lang.String getPortalIP() {
        return portalIP;
    }

    /**
     * deprecated
     * 
     * @param portalIP
     *     The portalIP
     */
    @JsonProperty("portalIP")
    public void setPortalIP(java.lang.String portalIP) {
        this.portalIP = portalIP;
    }

    /**
     * ports exposed by the service; see http://releases.k8s.io/v1.0.0/docs/services.md#virtual-ips-and-service-proxies
     * 
     * @return
     *     The ports
     */
    @JsonProperty("ports")
    public List<ServicePort> getPorts() {
        return ports;
    }

    /**
     * ports exposed by the service; see http://releases.k8s.io/v1.0.0/docs/services.md#virtual-ips-and-service-proxies
     * 
     * @param ports
     *     The ports
     */
    @JsonProperty("ports")
    public void setPorts(List<ServicePort> ports) {
        this.ports = ports;
    }

    /**
     * label keys and values that must match in order to receive traffic for this service; if empty
     * 
     * @return
     *     The selector
     */
    @JsonProperty("selector")
    public Map<String, String> getSelector() {
        return selector;
    }

    /**
     * label keys and values that must match in order to receive traffic for this service; if empty
     * 
     * @param selector
     *     The selector
     */
    @JsonProperty("selector")
    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    /**
     * enable client IP based session affinity; must be ClientIP or None; defaults to None; see http://releases.k8s.io/v1.0.0/docs/services.md#virtual-ips-and-service-proxies
     * 
     * @return
     *     The sessionAffinity
     */
    @JsonProperty("sessionAffinity")
    public java.lang.String getSessionAffinity() {
        return sessionAffinity;
    }

    /**
     * enable client IP based session affinity; must be ClientIP or None; defaults to None; see http://releases.k8s.io/v1.0.0/docs/services.md#virtual-ips-and-service-proxies
     * 
     * @param sessionAffinity
     *     The sessionAffinity
     */
    @JsonProperty("sessionAffinity")
    public void setSessionAffinity(java.lang.String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    /**
     * type of this service; must be ClusterIP
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public java.lang.String getType() {
        return type;
    }

    /**
     * type of this service; must be ClusterIP
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(java.lang.String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
