package io.fabric8.kubernetes.api.builder;

import java.util.List;
import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public  abstract class BaseFluent<T> implements Fluent<T>,Visitable<T>{


    public final List<Visitable> _visitables = new ArrayList<Visitable>();

    public <T> ArrayList<T> build( List<? extends Builder<? extends T>> list){
    ArrayList<T> r = new ArrayList<>();
for (Builder<? extends T> b : list) {
    r.add(b.build());
}
return r;

}
    public <T> LinkedHashSet<T> build( LinkedHashSet<? extends Builder<T>> set){
    LinkedHashSet<T> r = new LinkedHashSet<>();
for (Builder<T> b : set) {
    r.add(b.build());
}
return r;

}
    public <T> ArrayList<T> aggregate( List<? extends T> ...lists){
    ArrayList<T> result = new ArrayList<>();

for (List<? extends T> list : lists) {
    result.addAll(list);
}
return result;

}
    public <T> LinkedHashSet<T> aggregate( Set<? extends T> ...sets){
    LinkedHashSet<T> result = new LinkedHashSet<>();

for (Set<? extends T> set : sets) {
    result.addAll(set);
}
return result;

}
    private static <V, F> Boolean canVisit( V visitor,  F fluent){
    
for (java.lang.reflect.Method method : visitor.getClass().getDeclaredMethods()) {
    if (visitor instanceof TypedVisitor) {
        return ((TypedVisitor) visitor).getType().isAssignableFrom(fluent.getClass());
    }
    if (method.getParameterTypes().length != 1) {
        continue;
    }
    Class visitorType = method.getParameterTypes()[0];
    if (visitorType.isAssignableFrom(fluent.getClass())) {
        return true;
    } else {
        return false;
    }
}
return false;

}
    public T accept( Visitor visitor){
    for (Visitable v : _visitables) {
    v.accept(visitor);
}

if (canVisit(visitor,this)) {
    visitor.visit(this);
}

return (T) this;

}


}
