package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class AzureFileVolumeSourceFluentImpl<A extends AzureFileVolumeSourceFluent<A>> extends BaseFluent<A> implements AzureFileVolumeSourceFluent<A>{

     Boolean readOnly;     String secretName;     String shareName;
public AzureFileVolumeSourceFluentImpl(){
    
}
public AzureFileVolumeSourceFluentImpl( AzureFileVolumeSource instance ){
    this.withReadOnly(instance.getReadOnly()); this.withSecretName(instance.getSecretName()); this.withShareName(instance.getShareName()); 
}

    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public A withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (A) this;
    }
    public String getSecretName(){
    return this.secretName;
    }
    public A withSecretName( String secretName){
    this.secretName=secretName; return (A) this;
    }
    public String getShareName(){
    return this.shareName;
    }
    public A withShareName( String shareName){
    this.shareName=shareName; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
AzureFileVolumeSourceFluentImpl that = (AzureFileVolumeSourceFluentImpl) o;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
if (shareName != null ? !shareName.equals(that.shareName) :that.shareName != null) return false;
return true;

    }



}
