package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class CephFSVolumeSourceBuilder extends CephFSVolumeSourceFluentImpl<CephFSVolumeSourceBuilder> implements VisitableBuilder<CephFSVolumeSource,CephFSVolumeSourceBuilder>{

     CephFSVolumeSourceFluent<?> fluent;
public CephFSVolumeSourceBuilder(){
    this(new CephFSVolumeSource());
}
public CephFSVolumeSourceBuilder( CephFSVolumeSourceFluent<?> fluent ){
    this(fluent, new CephFSVolumeSource());
}
public CephFSVolumeSourceBuilder( CephFSVolumeSourceFluent<?> fluent , CephFSVolumeSource instance ){
    this.fluent = fluent; fluent.withMonitors(instance.getMonitors()); fluent.withPath(instance.getPath()); fluent.withReadOnly(instance.getReadOnly()); fluent.withSecretFile(instance.getSecretFile()); fluent.withSecretRef(instance.getSecretRef()); fluent.withUser(instance.getUser()); 
}
public CephFSVolumeSourceBuilder( CephFSVolumeSource instance ){
    this.fluent = this; this.withMonitors(instance.getMonitors()); this.withPath(instance.getPath()); this.withReadOnly(instance.getReadOnly()); this.withSecretFile(instance.getSecretFile()); this.withSecretRef(instance.getSecretRef()); this.withUser(instance.getUser()); 
}

public CephFSVolumeSource build(){
    CephFSVolumeSource buildable = new CephFSVolumeSource(fluent.getMonitors(),fluent.getPath(),fluent.isReadOnly(),fluent.getSecretFile(),fluent.getSecretRef(),fluent.getUser());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CephFSVolumeSourceBuilder that = (CephFSVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
