package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class CephFSVolumeSourceFluentImpl<A extends CephFSVolumeSourceFluent<A>> extends BaseFluent<A> implements CephFSVolumeSourceFluent<A>{

     List<String> monitors = new ArrayList();     String path;     Boolean readOnly;     String secretFile;     VisitableBuilder<LocalObjectReference, ?> secretRef;     String user;
public CephFSVolumeSourceFluentImpl(){
    
}
public CephFSVolumeSourceFluentImpl( CephFSVolumeSource instance ){
    this.withMonitors(instance.getMonitors()); this.withPath(instance.getPath()); this.withReadOnly(instance.getReadOnly()); this.withSecretFile(instance.getSecretFile()); this.withSecretRef(instance.getSecretRef()); this.withUser(instance.getUser()); 
}

    public A addToMonitors( String ...items){
    for (String item : items) {this.monitors.add(item);} return (A)this;
    }
    public A removeFromMonitors( String ...items){
    for (String item : items) {this.monitors.remove(item);} return (A)this;
    }
    public List<String> getMonitors(){
    return this.monitors;
    }
    public A withMonitors( List<String> monitors){
    this.monitors.clear();if (monitors != null) {for (String item : monitors){this.addToMonitors(item);}} return (A) this;
    }
    public A withMonitors( String ...monitors){
    this.monitors.clear(); if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (A) this;
    }
    public String getPath(){
    return this.path;
    }
    public A withPath( String path){
    this.path=path; return (A) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public A withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (A) this;
    }
    public String getSecretFile(){
    return this.secretFile;
    }
    public A withSecretFile( String secretFile){
    this.secretFile=secretFile; return (A) this;
    }
    public LocalObjectReference getSecretRef(){
    return this.secretRef!=null?this.secretRef.build():null;
    }
    public A withSecretRef( LocalObjectReference secretRef){
    if (secretRef!=null){ this.secretRef= new LocalObjectReferenceBuilder(secretRef); _visitables.add(this.secretRef);} return (A) this;
    }
    public SecretRefNested<A> withNewSecretRef(){
    return new SecretRefNestedImpl();
    }
    public SecretRefNested<A> withNewSecretRefLike( LocalObjectReference item){
    return new SecretRefNestedImpl(item);
    }
    public SecretRefNested<A> editSecretRef(){
    return withNewSecretRefLike(getSecretRef());
    }
    public A withNewSecretRef( String name){
    return withSecretRef(new LocalObjectReference(name));
    }
    public String getUser(){
    return this.user;
    }
    public A withUser( String user){
    this.user=user; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
CephFSVolumeSourceFluentImpl that = (CephFSVolumeSourceFluentImpl) o;
if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (secretFile != null ? !secretFile.equals(that.secretFile) :that.secretFile != null) return false;
if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
return true;

    }

    public class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretRefNested<N>> implements SecretRefNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SecretRefNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             SecretRefNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N endSecretRef(){
            return and();
        }
            public N and(){
            return (N) CephFSVolumeSourceFluentImpl.this.withSecretRef(builder.build());
        }
    
}


}
