package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class CinderVolumeSourceFluentImpl<A extends CinderVolumeSourceFluent<A>> extends BaseFluent<A> implements CinderVolumeSourceFluent<A>{

     String fsType;     Boolean readOnly;     String volumeID;
public CinderVolumeSourceFluentImpl(){
    
}
public CinderVolumeSourceFluentImpl( CinderVolumeSource instance ){
    this.withFsType(instance.getFsType()); this.withReadOnly(instance.getReadOnly()); this.withVolumeID(instance.getVolumeID()); 
}

    public String getFsType(){
    return this.fsType;
    }
    public A withFsType( String fsType){
    this.fsType=fsType; return (A) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public A withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (A) this;
    }
    public String getVolumeID(){
    return this.volumeID;
    }
    public A withVolumeID( String volumeID){
    this.volumeID=volumeID; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
CinderVolumeSourceFluentImpl that = (CinderVolumeSourceFluentImpl) o;
if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (volumeID != null ? !volumeID.equals(that.volumeID) :that.volumeID != null) return false;
return true;

    }



}
