package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public A addToClusters( NamedCluster ...items);    public A removeFromClusters( NamedCluster ...items);    public List<NamedCluster> getClusters();    public A withClusters( List<NamedCluster> clusters);    public A withClusters( NamedCluster ...clusters);    public ClustersNested<A> addNewCluster();    public ClustersNested<A> addNewClusterLike( NamedCluster item);    public A addToContexts( NamedContext ...items);    public A removeFromContexts( NamedContext ...items);    public List<NamedContext> getContexts();    public A withContexts( List<NamedContext> contexts);    public A withContexts( NamedContext ...contexts);    public ContextsNested<A> addNewContext();    public ContextsNested<A> addNewContextLike( NamedContext item);    public String getCurrentContext();    public A withCurrentContext( String currentContext);    public A addToExtensions( NamedExtension ...items);    public A removeFromExtensions( NamedExtension ...items);    public List<NamedExtension> getExtensions();    public A withExtensions( List<NamedExtension> extensions);    public A withExtensions( NamedExtension ...extensions);    public ExtensionsNested<A> addNewExtension();    public ExtensionsNested<A> addNewExtensionLike( NamedExtension item);    public String getKind();    public A withKind( String kind);    public Preferences getPreferences();    public A withPreferences( Preferences preferences);    public PreferencesNested<A> withNewPreferences();    public PreferencesNested<A> withNewPreferencesLike( Preferences item);    public PreferencesNested<A> editPreferences();    public A addToUsers( NamedAuthInfo ...items);    public A removeFromUsers( NamedAuthInfo ...items);    public List<NamedAuthInfo> getUsers();    public A withUsers( List<NamedAuthInfo> users);    public A withUsers( NamedAuthInfo ...users);    public UsersNested<A> addNewUser();    public UsersNested<A> addNewUserLike( NamedAuthInfo item);
    public interface ClustersNested<N> extends Nested<N>,NamedClusterFluent<ClustersNested<N>>{
            public N endCluster();            public N and();        
}

    public interface ContextsNested<N> extends Nested<N>,NamedContextFluent<ContextsNested<N>>{
            public N endContext();            public N and();        
}

    public interface ExtensionsNested<N> extends Nested<N>,NamedExtensionFluent<ExtensionsNested<N>>{
            public N and();            public N endExtension();        
}

    public interface PreferencesNested<N> extends Nested<N>,PreferencesFluent<PreferencesNested<N>>{
            public N and();            public N endPreferences();        
}

    public interface UsersNested<N> extends Nested<N>,NamedAuthInfoFluent<UsersNested<N>>{
            public N and();            public N endUser();        
}


}
