package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class ConfigMapFluentImpl<A extends ConfigMapFluent<A>> extends BaseFluent<A> implements ConfigMapFluent<A>{

     String apiVersion;     Map<String, String> data = new HashMap();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;
public ConfigMapFluentImpl(){
    
}
public ConfigMapFluentImpl( ConfigMap instance ){
    this.withApiVersion(instance.getApiVersion()); this.withData(instance.getData()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public A addToData( String key,  String value){
    if(key != null && value != null) {this.data.put(key, value);} return (A)this;
    }
    public A addToData( Map<String, String> map){
    if(map != null) { this.data.putAll(map);} return (A)this;
    }
    public A removeFromData( String key){
    if(key != null) {this.data.remove(key);} return (A)this;
    }
    public A removeFromData( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.data.remove(key);}} return (A)this;
    }
    public Map<String, String> getData(){
    return this.data;
    }
    public A withData( Map<String, String> data){
    this.data.clear();if (data != null) {this.data.putAll(data);} return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ConfigMapFluentImpl that = (ConfigMapFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (data != null ? !data.equals(that.data) :that.data != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ConfigMapFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
