package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;

public class ConfigMapVolumeSourceFluentImpl<A extends ConfigMapVolumeSourceFluent<A>> extends BaseFluent<A> implements ConfigMapVolumeSourceFluent<A>{

     List<VisitableBuilder<KeyToPath, ?>> items = new ArrayList();     String name;
public ConfigMapVolumeSourceFluentImpl(){
    
}
public ConfigMapVolumeSourceFluentImpl( ConfigMapVolumeSource instance ){
    this.withItems(instance.getItems()); this.withName(instance.getName()); 
}

    public A addToItems( KeyToPath ...items){
    for (KeyToPath item : items) {KeyToPathBuilder builder = new KeyToPathBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }
    public A removeFromItems( KeyToPath ...items){
    for (KeyToPath item : items) {KeyToPathBuilder builder = new KeyToPathBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }
    public List<KeyToPath> getItems(){
    return build(items);
    }
    public A withItems( List<KeyToPath> items){
    this.items.clear();if (items != null) {for (KeyToPath item : items){this.addToItems(item);}} return (A) this;
    }
    public A withItems( KeyToPath ...items){
    this.items.clear(); if (items != null) {for (KeyToPath item :items){ this.addToItems(item);}} return (A) this;
    }
    public ItemsNested<A> addNewItem(){
    return new ItemsNestedImpl();
    }
    public ItemsNested<A> addNewItemLike( KeyToPath item){
    return new ItemsNestedImpl(item);
    }
    public A addNewItem( String key,  String path){
    return addToItems(new KeyToPath(key, path));
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ConfigMapVolumeSourceFluentImpl that = (ConfigMapVolumeSourceFluentImpl) o;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
return true;

    }

    public class ItemsNestedImpl<N> extends KeyToPathFluentImpl<ItemsNested<N>> implements ItemsNested<N>{

        private final KeyToPathBuilder builder;
    
             ItemsNestedImpl (){
        this.builder = new KeyToPathBuilder(this);
        }
             ItemsNestedImpl ( KeyToPath item){
        this.builder = new KeyToPathBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) ConfigMapVolumeSourceFluentImpl.this.addToItems(builder.build());
        }
    
}


}
