package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ContainerImageFluentImpl<A extends ContainerImageFluent<A>> extends BaseFluent<A> implements ContainerImageFluent<A>{

     List<String> names = new ArrayList();     Long sizeBytes;
public ContainerImageFluentImpl(){
    
}
public ContainerImageFluentImpl( ContainerImage instance ){
    this.withNames(instance.getNames()); this.withSizeBytes(instance.getSizeBytes()); 
}

    public A addToNames( String ...items){
    for (String item : items) {this.names.add(item);} return (A)this;
    }
    public A removeFromNames( String ...items){
    for (String item : items) {this.names.remove(item);} return (A)this;
    }
    public List<String> getNames(){
    return this.names;
    }
    public A withNames( List<String> names){
    this.names.clear();if (names != null) {for (String item : names){this.addToNames(item);}} return (A) this;
    }
    public A withNames( String ...names){
    this.names.clear(); if (names != null) {for (String item :names){ this.addToNames(item);}} return (A) this;
    }
    public Long getSizeBytes(){
    return this.sizeBytes;
    }
    public A withSizeBytes( Long sizeBytes){
    this.sizeBytes=sizeBytes; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerImageFluentImpl that = (ContainerImageFluentImpl) o;
if (names != null ? !names.equals(that.names) :that.names != null) return false;
if (sizeBytes != null ? !sizeBytes.equals(that.sizeBytes) :that.sizeBytes != null) return false;
return true;

    }



}
