package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ContainerPortBuilder extends ContainerPortFluentImpl<ContainerPortBuilder> implements VisitableBuilder<ContainerPort,ContainerPortBuilder>{

     ContainerPortFluent<?> fluent;
public ContainerPortBuilder(){
    this(new ContainerPort());
}
public ContainerPortBuilder( ContainerPortFluent<?> fluent ){
    this(fluent, new ContainerPort());
}
public ContainerPortBuilder( ContainerPortFluent<?> fluent , ContainerPort instance ){
    this.fluent = fluent; fluent.withContainerPort(instance.getContainerPort()); fluent.withHostIP(instance.getHostIP()); fluent.withHostPort(instance.getHostPort()); fluent.withName(instance.getName()); fluent.withProtocol(instance.getProtocol()); 
}
public ContainerPortBuilder( ContainerPort instance ){
    this.fluent = this; this.withContainerPort(instance.getContainerPort()); this.withHostIP(instance.getHostIP()); this.withHostPort(instance.getHostPort()); this.withName(instance.getName()); this.withProtocol(instance.getProtocol()); 
}

public ContainerPort build(){
    ContainerPort buildable = new ContainerPort(fluent.getContainerPort(),fluent.getHostIP(),fluent.getHostPort(),fluent.getName(),fluent.getProtocol());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerPortBuilder that = (ContainerPortBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
