package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ContainerStateBuilder extends ContainerStateFluentImpl<ContainerStateBuilder> implements VisitableBuilder<ContainerState,ContainerStateBuilder>{

     ContainerStateFluent<?> fluent;
public ContainerStateBuilder(){
    this(new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent ){
    this(fluent, new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent , ContainerState instance ){
    this.fluent = fluent; fluent.withRunning(instance.getRunning()); fluent.withTerminated(instance.getTerminated()); fluent.withWaiting(instance.getWaiting()); 
}
public ContainerStateBuilder( ContainerState instance ){
    this.fluent = this; this.withRunning(instance.getRunning()); this.withTerminated(instance.getTerminated()); this.withWaiting(instance.getWaiting()); 
}

public ContainerState build(){
    ContainerState buildable = new ContainerState(fluent.getRunning(),fluent.getTerminated(),fluent.getWaiting());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerStateBuilder that = (ContainerStateBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
